/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AmazonMWSLinkedService
extends LinkedService {
    private String type = "AmazonMWS";
    private Object endpoint;
    private Object marketplaceID;
    private Object sellerID;
    private SecretBase mwsAuthToken;
    private Object accessKeyId;
    private SecretBase secretKey;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public AmazonMWSLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getMarketplaceID() {
        return this.marketplaceID;
    }

    public AmazonMWSLinkedService setMarketplaceID(Object marketplaceID) {
        this.marketplaceID = marketplaceID;
        return this;
    }

    public Object getSellerID() {
        return this.sellerID;
    }

    public AmazonMWSLinkedService setSellerID(Object sellerID) {
        this.sellerID = sellerID;
        return this;
    }

    public SecretBase getMwsAuthToken() {
        return this.mwsAuthToken;
    }

    public AmazonMWSLinkedService setMwsAuthToken(SecretBase mwsAuthToken) {
        this.mwsAuthToken = mwsAuthToken;
        return this;
    }

    public Object getAccessKeyId() {
        return this.accessKeyId;
    }

    public AmazonMWSLinkedService setAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase getSecretKey() {
        return this.secretKey;
    }

    public AmazonMWSLinkedService setSecretKey(SecretBase secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public AmazonMWSLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getUseHostVerification() {
        return this.useHostVerification;
    }

    public AmazonMWSLinkedService setUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object getUsePeerVerification() {
        return this.usePeerVerification;
    }

    public AmazonMWSLinkedService setUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonMWSLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public AmazonMWSLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AmazonMWSLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AmazonMWSLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AmazonMWSLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AmazonMWSLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.marketplaceID != null || this.sellerID != null || this.mwsAuthToken != null || this.accessKeyId != null || this.secretKey != null || this.useEncryptedEndpoints != null || this.useHostVerification != null || this.usePeerVerification != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeUntypedField("marketplaceID", this.marketplaceID);
            jsonWriter.writeUntypedField("sellerID", this.sellerID);
            jsonWriter.writeJsonField("mwsAuthToken", (JsonSerializable)this.mwsAuthToken);
            jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
            jsonWriter.writeJsonField("secretKey", (JsonSerializable)this.secretKey);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.useHostVerification != null) {
                jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
            }
            if (this.usePeerVerification != null) {
                jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonMWSLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonMWSLinkedService)jsonReader.readObject(reader -> {
            AmazonMWSLinkedService deserializedAmazonMWSLinkedService = new AmazonMWSLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAmazonMWSLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAmazonMWSLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonMWSLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonMWSLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonMWSLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonMWSLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("marketplaceID".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.marketplaceID = reader.readUntyped();
                            continue;
                        }
                        if ("sellerID".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.sellerID = reader.readUntyped();
                            continue;
                        }
                        if ("mwsAuthToken".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.mwsAuthToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("accessKeyId".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.accessKeyId = reader.readUntyped();
                            continue;
                        }
                        if ("secretKey".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.secretKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("useHostVerification".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.useHostVerification = reader.readUntyped();
                            continue;
                        }
                        if ("usePeerVerification".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.usePeerVerification = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAmazonMWSLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonMWSLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAmazonMWSLinkedService;
        });
    }
}

