/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.Workspace;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class WorkspacesImpl {
    private final WorkspacesService service;
    private final ArtifactsClientImpl client;

    WorkspacesImpl(ArtifactsClientImpl client) {
        this.service = (WorkspacesService)RestProxy.create(WorkspacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Workspace>> getWithResponseAsync() {
        return FluxUtil.withContext(context -> this.getWithResponseAsync((Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Workspace>> getWithResponseAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Workspace> getAsync() {
        return this.getWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((Workspace)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Workspace> getAsync(Context context) {
        return this.getWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((Workspace)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Workspace> getWithResponse(Context context) {
        return (Response)this.getWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Workspace get() {
        return (Workspace)this.getWithResponse(Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientWorkspaces")
    public static interface WorkspacesService {
        @Get(value="/workspace")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<Workspace>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

