/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.DataFlowListResponse;
import com.azure.analytics.synapse.artifacts.models.DataFlowResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class DataFlowsImpl {
    private final DataFlowsService service;
    private final ArtifactsClientImpl client;

    DataFlowsImpl(ArtifactsClientImpl client) {
        this.service = (DataFlowsService)RestProxy.create(DataFlowsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> createOrUpdateDataFlowWithResponseAsync(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return FluxUtil.withContext(context -> this.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> createOrUpdateDataFlowWithResponseAsync(String dataFlowName, DataFlowResource dataFlow, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateDataFlow(this.client.getEndpoint(), dataFlowName, "2020-12-01", ifMatch, dataFlow, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> createOrUpdateDataFlowAsync(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return this.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> createOrUpdateDataFlowAsync(String dataFlowName, DataFlowResource dataFlow) {
        String ifMatch = null;
        return this.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> createOrUpdateDataFlowAsync(String dataFlowName, DataFlowResource dataFlow, String ifMatch, Context context) {
        return this.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFlowResource> createOrUpdateDataFlowWithResponse(String dataFlowName, DataFlowResource dataFlow, String ifMatch, Context context) {
        return (Response)this.createOrUpdateDataFlowWithResponseAsync(dataFlowName, dataFlow, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return (DataFlowResource)this.createOrUpdateDataFlowWithResponse(dataFlowName, dataFlow, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow) {
        String ifMatch = null;
        return (DataFlowResource)this.createOrUpdateDataFlowWithResponse(dataFlowName, dataFlow, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> getDataFlowWithResponseAsync(String dataFlowName, String ifNoneMatch) {
        return FluxUtil.withContext(context -> this.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataFlowResource>> getDataFlowWithResponseAsync(String dataFlowName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getDataFlow(this.client.getEndpoint(), dataFlowName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> getDataFlowAsync(String dataFlowName, String ifNoneMatch) {
        return this.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> getDataFlowAsync(String dataFlowName) {
        String ifNoneMatch = null;
        return this.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowResource> getDataFlowAsync(String dataFlowName, String ifNoneMatch, Context context) {
        return this.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((DataFlowResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFlowResource> getDataFlowWithResponse(String dataFlowName, String ifNoneMatch, Context context) {
        return (Response)this.getDataFlowWithResponseAsync(dataFlowName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource getDataFlow(String dataFlowName, String ifNoneMatch) {
        return (DataFlowResource)this.getDataFlowWithResponse(dataFlowName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource getDataFlow(String dataFlowName) {
        String ifNoneMatch = null;
        return (DataFlowResource)this.getDataFlowWithResponse(dataFlowName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFlowWithResponseAsync(String dataFlowName) {
        return FluxUtil.withContext(context -> this.deleteDataFlowWithResponseAsync(dataFlowName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFlowWithResponseAsync(String dataFlowName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteDataFlow(this.client.getEndpoint(), dataFlowName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFlowAsync(String dataFlowName) {
        return this.deleteDataFlowWithResponseAsync(dataFlowName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFlowAsync(String dataFlowName, Context context) {
        return this.deleteDataFlowWithResponseAsync(dataFlowName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataFlowWithResponse(String dataFlowName, Context context) {
        return (Response)this.deleteDataFlowWithResponseAsync(dataFlowName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataFlow(String dataFlowName) {
        this.deleteDataFlowWithResponse(dataFlowName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDataFlowWithResponseAsync(String dataFlowName, ArtifactRenameRequest request) {
        return FluxUtil.withContext(context -> this.renameDataFlowWithResponseAsync(dataFlowName, request, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDataFlowWithResponseAsync(String dataFlowName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameDataFlow(this.client.getEndpoint(), dataFlowName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDataFlowAsync(String dataFlowName, ArtifactRenameRequest request) {
        return this.renameDataFlowWithResponseAsync(dataFlowName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDataFlowAsync(String dataFlowName, ArtifactRenameRequest request, Context context) {
        return this.renameDataFlowWithResponseAsync(dataFlowName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameDataFlowWithResponse(String dataFlowName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameDataFlowWithResponseAsync(dataFlowName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameDataFlow(String dataFlowName, ArtifactRenameRequest request) {
        this.renameDataFlowWithResponse(dataFlowName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowResource>> getDataFlowsByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDataFlowsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFlowListResponse)res.getValue()).getValue(), ((DataFlowListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowResource>> getDataFlowsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getDataFlowsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFlowListResponse)res.getValue()).getValue(), ((DataFlowListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFlowResource> getDataFlowsByWorkspaceAsync() {
        return new PagedFlux(() -> this.getDataFlowsByWorkspaceSinglePageAsync(), nextLink -> this.getDataFlowsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFlowResource> getDataFlowsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getDataFlowsByWorkspaceSinglePageAsync(context), nextLink -> this.getDataFlowsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DataFlowResource> getDataFlowsByWorkspaceSinglePage() {
        return (PagedResponse)this.getDataFlowsByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DataFlowResource> getDataFlowsByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getDataFlowsByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowResource> getDataFlowsByWorkspace() {
        return new PagedIterable(this.getDataFlowsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowResource> getDataFlowsByWorkspace(Context context) {
        return new PagedIterable(this.getDataFlowsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowResource>> getDataFlowsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDataFlowsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFlowListResponse)res.getValue()).getValue(), ((DataFlowListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowResource>> getDataFlowsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getDataFlowsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataFlowListResponse)res.getValue()).getValue(), ((DataFlowListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DataFlowResource> getDataFlowsByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getDataFlowsByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DataFlowResource> getDataFlowsByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getDataFlowsByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientDataFlows")
    public static interface DataFlowsService {
        @Put(value="/dataflows/{dataFlowName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DataFlowResource>> createOrUpdateDataFlow(@HostParam(value="endpoint") String var1, @PathParam(value="dataFlowName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") DataFlowResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/dataflows/{dataFlowName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DataFlowResource>> getDataFlow(@HostParam(value="endpoint") String var1, @PathParam(value="dataFlowName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/dataflows/{dataFlowName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteDataFlow(@HostParam(value="endpoint") String var1, @PathParam(value="dataFlowName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/dataflows/{dataFlowName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameDataFlow(@HostParam(value="endpoint") String var1, @PathParam(value="dataFlowName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/dataflows")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DataFlowListResponse>> getDataFlowsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<DataFlowListResponse>> getDataFlowsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

