/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SqlScriptsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SqlScriptResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class SqlScriptAsyncClient {
    private final SqlScriptsImpl serviceClient;

    SqlScriptAsyncClient(SqlScriptsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlScriptResource> getSqlScriptsByWorkspace() {
        return this.serviceClient.getSqlScriptsByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> createOrUpdateSqlScriptWithResponse(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        return this.serviceClient.createOrUpdateSqlScriptWithResponseAsync(sqlScriptName, sqlScript, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        return this.serviceClient.createOrUpdateSqlScriptAsync(sqlScriptName, sqlScript, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript) {
        return this.serviceClient.createOrUpdateSqlScriptAsync(sqlScriptName, sqlScript);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> getSqlScriptWithResponse(String sqlScriptName, String ifNoneMatch) {
        return this.serviceClient.getSqlScriptWithResponseAsync(sqlScriptName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> getSqlScript(String sqlScriptName, String ifNoneMatch) {
        return this.serviceClient.getSqlScriptAsync(sqlScriptName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> getSqlScript(String sqlScriptName) {
        return this.serviceClient.getSqlScriptAsync(sqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSqlScriptWithResponse(String sqlScriptName) {
        return this.serviceClient.deleteSqlScriptWithResponseAsync(sqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSqlScript(String sqlScriptName) {
        return this.serviceClient.deleteSqlScriptAsync(sqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSqlScriptWithResponse(String sqlScriptName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSqlScriptWithResponseAsync(sqlScriptName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSqlScript(String sqlScriptName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSqlScriptAsync(sqlScriptName, request);
    }
}

