/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.RunNotebooksImpl;
import com.azure.analytics.synapse.artifacts.models.RunNotebookRequest;
import com.azure.analytics.synapse.artifacts.models.RunNotebookResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebookSnapshotResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebooksCreateRunHeaders;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class RunNotebookAsyncClient {
    private final RunNotebooksImpl serviceClient;

    RunNotebookAsyncClient(RunNotebooksImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<RunNotebooksCreateRunHeaders, RunNotebookResponse>> createRunWithResponse(String runId, RunNotebookRequest runNotebookRequest) {
        return this.serviceClient.createRunWithResponseAsync(runId, runNotebookRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> createRun(String runId, RunNotebookRequest runNotebookRequest) {
        return this.serviceClient.createRunAsync(runId, runNotebookRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> createRunNoCustomHeadersWithResponse(String runId, RunNotebookRequest runNotebookRequest) {
        return this.serviceClient.createRunNoCustomHeadersWithResponseAsync(runId, runNotebookRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> getStatusWithResponse(String runId) {
        return this.serviceClient.getStatusWithResponseAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> getStatus(String runId) {
        return this.serviceClient.getStatusAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> cancelRunWithResponse(String runId) {
        return this.serviceClient.cancelRunWithResponseAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> cancelRun(String runId) {
        return this.serviceClient.cancelRunAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookSnapshotResponse>> getSnapshotWithResponse(String runId) {
        return this.serviceClient.getSnapshotWithResponseAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookSnapshotResponse> getSnapshot(String runId) {
        return this.serviceClient.getSnapshotAsync(runId);
    }
}

