/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.PipelineRunsImpl;
import com.azure.analytics.synapse.artifacts.models.ActivityRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineRun;
import com.azure.analytics.synapse.artifacts.models.PipelineRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.RunFilterParameters;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class PipelineRunAsyncClient {
    private final PipelineRunsImpl serviceClient;

    PipelineRunAsyncClient(PipelineRunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRunsQueryResponse>> queryPipelineRunsByWorkspaceWithResponse(RunFilterParameters filterParameters) {
        return this.serviceClient.queryPipelineRunsByWorkspaceWithResponseAsync(filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRunsQueryResponse> queryPipelineRunsByWorkspace(RunFilterParameters filterParameters) {
        return this.serviceClient.queryPipelineRunsByWorkspaceAsync(filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRun>> getPipelineRunWithResponse(String runId) {
        return this.serviceClient.getPipelineRunWithResponseAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRun> getPipelineRun(String runId) {
        return this.serviceClient.getPipelineRunAsync(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActivityRunsQueryResponse>> queryActivityRunsWithResponse(String pipelineName, String runId, RunFilterParameters filterParameters) {
        return this.serviceClient.queryActivityRunsWithResponseAsync(pipelineName, runId, filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActivityRunsQueryResponse> queryActivityRuns(String pipelineName, String runId, RunFilterParameters filterParameters) {
        return this.serviceClient.queryActivityRunsAsync(pipelineName, runId, filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelPipelineRunWithResponse(String runId, Boolean isRecursive) {
        return this.serviceClient.cancelPipelineRunWithResponseAsync(runId, isRecursive);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelPipelineRun(String runId, Boolean isRecursive) {
        return this.serviceClient.cancelPipelineRunAsync(runId, isRecursive);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelPipelineRun(String runId) {
        return this.serviceClient.cancelPipelineRunAsync(runId);
    }
}

