/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LinkedServicesImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class LinkedServiceAsyncClient {
    private final LinkedServicesImpl serviceClient;

    LinkedServiceAsyncClient(LinkedServicesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkedServiceResource> getLinkedServicesByWorkspace() {
        return this.serviceClient.getLinkedServicesByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> createOrUpdateLinkedServiceWithResponse(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        return this.serviceClient.createOrUpdateLinkedServiceWithResponseAsync(linkedServiceName, linkedService, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        return this.serviceClient.createOrUpdateLinkedServiceAsync(linkedServiceName, linkedService, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService) {
        return this.serviceClient.createOrUpdateLinkedServiceAsync(linkedServiceName, linkedService);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> getLinkedServiceWithResponse(String linkedServiceName, String ifNoneMatch) {
        return this.serviceClient.getLinkedServiceWithResponseAsync(linkedServiceName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> getLinkedService(String linkedServiceName, String ifNoneMatch) {
        return this.serviceClient.getLinkedServiceAsync(linkedServiceName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> getLinkedService(String linkedServiceName) {
        return this.serviceClient.getLinkedServiceAsync(linkedServiceName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteLinkedServiceWithResponse(String linkedServiceName) {
        return this.serviceClient.deleteLinkedServiceWithResponseAsync(linkedServiceName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteLinkedService(String linkedServiceName) {
        return this.serviceClient.deleteLinkedServiceAsync(linkedServiceName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameLinkedServiceWithResponse(String linkedServiceName, ArtifactRenameRequest request) {
        return this.serviceClient.renameLinkedServiceWithResponseAsync(linkedServiceName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameLinkedService(String linkedServiceName, ArtifactRenameRequest request) {
        return this.serviceClient.renameLinkedServiceAsync(linkedServiceName, request);
    }
}

