/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LinkConnectionsImpl;
import com.azure.analytics.synapse.artifacts.models.EditTablesRequest;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionDetailedStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionQueryTableStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionResource;
import com.azure.analytics.synapse.artifacts.models.LinkTableListResponse;
import com.azure.analytics.synapse.artifacts.models.QueryTableStatusRequest;
import com.azure.analytics.synapse.artifacts.models.UpdateLandingZoneCredential;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class LinkConnectionClient {
    private final LinkConnectionsImpl serviceClient;

    LinkConnectionClient(LinkConnectionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkConnectionResource> listByWorkspace() {
        return this.serviceClient.listByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkConnectionResource> listByWorkspace(Context context) {
        return this.serviceClient.listByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionResource> createOrUpdateWithResponse(String linkConnectionName, LinkConnectionResource linkConnection, Context context) {
        return this.serviceClient.createOrUpdateWithResponse(linkConnectionName, linkConnection, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionResource createOrUpdate(String linkConnectionName, LinkConnectionResource linkConnection) {
        return this.serviceClient.createOrUpdate(linkConnectionName, linkConnection);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionResource> getWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.getWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionResource get(String linkConnectionName) {
        return this.serviceClient.get(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.deleteWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String linkConnectionName) {
        this.serviceClient.delete(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> editTablesWithResponse(String linkConnectionName, EditTablesRequest editTablesRequest, Context context) {
        return this.serviceClient.editTablesWithResponse(linkConnectionName, editTablesRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void editTables(String linkConnectionName, EditTablesRequest editTablesRequest) {
        this.serviceClient.editTables(linkConnectionName, editTablesRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.startWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String linkConnectionName) {
        this.serviceClient.start(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.stopWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String linkConnectionName) {
        this.serviceClient.stop(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionDetailedStatus> getDetailedStatusWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.getDetailedStatusWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionDetailedStatus getDetailedStatus(String linkConnectionName) {
        return this.serviceClient.getDetailedStatus(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkTableListResponse> listLinkTablesWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.listLinkTablesWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkTableListResponse listLinkTables(String linkConnectionName) {
        return this.serviceClient.listLinkTables(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionQueryTableStatus> queryTableStatusWithResponse(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, Context context) {
        return this.serviceClient.queryTableStatusWithResponse(linkConnectionName, queryTableStatusRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionQueryTableStatus queryTableStatus(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        return this.serviceClient.queryTableStatus(linkConnectionName, queryTableStatusRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateLandingZoneCredentialWithResponse(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, Context context) {
        return this.serviceClient.updateLandingZoneCredentialWithResponse(linkConnectionName, updateLandingZoneCredentialRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateLandingZoneCredential(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        this.serviceClient.updateLandingZoneCredential(linkConnectionName, updateLandingZoneCredentialRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.pauseWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pause(String linkConnectionName) {
        this.serviceClient.pause(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeWithResponse(String linkConnectionName, Context context) {
        return this.serviceClient.resumeWithResponse(linkConnectionName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String linkConnectionName) {
        this.serviceClient.resume(linkConnectionName);
    }
}

