/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LinkConnectionsImpl;
import com.azure.analytics.synapse.artifacts.models.EditTablesRequest;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionDetailedStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionQueryTableStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionResource;
import com.azure.analytics.synapse.artifacts.models.LinkTableListResponse;
import com.azure.analytics.synapse.artifacts.models.QueryTableStatusRequest;
import com.azure.analytics.synapse.artifacts.models.UpdateLandingZoneCredential;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class LinkConnectionAsyncClient {
    private final LinkConnectionsImpl serviceClient;

    LinkConnectionAsyncClient(LinkConnectionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkConnectionResource> listByWorkspace() {
        return this.serviceClient.listByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> createOrUpdateWithResponse(String linkConnectionName, LinkConnectionResource linkConnection) {
        return this.serviceClient.createOrUpdateWithResponseAsync(linkConnectionName, linkConnection);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> createOrUpdate(String linkConnectionName, LinkConnectionResource linkConnection) {
        return this.serviceClient.createOrUpdateAsync(linkConnectionName, linkConnection);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> getWithResponse(String linkConnectionName) {
        return this.serviceClient.getWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> get(String linkConnectionName) {
        return this.serviceClient.getAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String linkConnectionName) {
        return this.serviceClient.deleteWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String linkConnectionName) {
        return this.serviceClient.deleteAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> editTablesWithResponse(String linkConnectionName, EditTablesRequest editTablesRequest) {
        return this.serviceClient.editTablesWithResponseAsync(linkConnectionName, editTablesRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> editTables(String linkConnectionName, EditTablesRequest editTablesRequest) {
        return this.serviceClient.editTablesAsync(linkConnectionName, editTablesRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startWithResponse(String linkConnectionName) {
        return this.serviceClient.startWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> start(String linkConnectionName) {
        return this.serviceClient.startAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopWithResponse(String linkConnectionName) {
        return this.serviceClient.stopWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stop(String linkConnectionName) {
        return this.serviceClient.stopAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionDetailedStatus>> getDetailedStatusWithResponse(String linkConnectionName) {
        return this.serviceClient.getDetailedStatusWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionDetailedStatus> getDetailedStatus(String linkConnectionName) {
        return this.serviceClient.getDetailedStatusAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkTableListResponse>> listLinkTablesWithResponse(String linkConnectionName) {
        return this.serviceClient.listLinkTablesWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkTableListResponse> listLinkTables(String linkConnectionName) {
        return this.serviceClient.listLinkTablesAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionQueryTableStatus>> queryTableStatusWithResponse(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        return this.serviceClient.queryTableStatusWithResponseAsync(linkConnectionName, queryTableStatusRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionQueryTableStatus> queryTableStatus(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        return this.serviceClient.queryTableStatusAsync(linkConnectionName, queryTableStatusRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateLandingZoneCredentialWithResponse(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        return this.serviceClient.updateLandingZoneCredentialWithResponseAsync(linkConnectionName, updateLandingZoneCredentialRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateLandingZoneCredential(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        return this.serviceClient.updateLandingZoneCredentialAsync(linkConnectionName, updateLandingZoneCredentialRequest);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseWithResponse(String linkConnectionName) {
        return this.serviceClient.pauseWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pause(String linkConnectionName) {
        return this.serviceClient.pauseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeWithResponse(String linkConnectionName) {
        return this.serviceClient.resumeWithResponseAsync(linkConnectionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resume(String linkConnectionName) {
        return this.serviceClient.resumeAsync(linkConnectionName);
    }
}

