/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.IntegrationRuntimesImpl;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeListResponse;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class IntegrationRuntimesAsyncClient {
    private final IntegrationRuntimesImpl serviceClient;

    IntegrationRuntimesAsyncClient(IntegrationRuntimesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeListResponse>> listWithResponse() {
        return this.serviceClient.listWithResponseAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeListResponse> list() {
        return this.serviceClient.listAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IntegrationRuntimeResource>> getWithResponse(String integrationRuntimeName) {
        return this.serviceClient.getWithResponseAsync(integrationRuntimeName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IntegrationRuntimeResource> get(String integrationRuntimeName) {
        return this.serviceClient.getAsync(integrationRuntimeName);
    }
}

