/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.DatasetsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.DatasetResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class DatasetAsyncClient {
    private final DatasetsImpl serviceClient;

    DatasetAsyncClient(DatasetsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatasetResource> getDatasetsByWorkspace() {
        return this.serviceClient.getDatasetsByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> createOrUpdateDatasetWithResponse(String datasetName, DatasetResource dataset, String ifMatch) {
        return this.serviceClient.createOrUpdateDatasetWithResponseAsync(datasetName, dataset, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> createOrUpdateDataset(String datasetName, DatasetResource dataset, String ifMatch) {
        return this.serviceClient.createOrUpdateDatasetAsync(datasetName, dataset, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> createOrUpdateDataset(String datasetName, DatasetResource dataset) {
        return this.serviceClient.createOrUpdateDatasetAsync(datasetName, dataset);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatasetResource>> getDatasetWithResponse(String datasetName, String ifNoneMatch) {
        return this.serviceClient.getDatasetWithResponseAsync(datasetName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> getDataset(String datasetName, String ifNoneMatch) {
        return this.serviceClient.getDatasetAsync(datasetName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetResource> getDataset(String datasetName) {
        return this.serviceClient.getDatasetAsync(datasetName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDatasetWithResponse(String datasetName) {
        return this.serviceClient.deleteDatasetWithResponseAsync(datasetName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataset(String datasetName) {
        return this.serviceClient.deleteDatasetAsync(datasetName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameDatasetWithResponse(String datasetName, ArtifactRenameRequest request) {
        return this.serviceClient.renameDatasetWithResponseAsync(datasetName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameDataset(String datasetName, ArtifactRenameRequest request) {
        return this.serviceClient.renameDatasetAsync(datasetName, request);
    }
}

