/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AddressValue;
import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.CurrencyValue;
import com.azure.ai.documentintelligence.models.DocumentFieldType;
import com.azure.ai.documentintelligence.models.DocumentSelectionMarkState;
import com.azure.ai.documentintelligence.models.DocumentSignatureType;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DocumentField
implements JsonSerializable<DocumentField> {
    private final DocumentFieldType type;
    private String valueString;
    private LocalDate valueDate;
    private String valueTime;
    private String valuePhoneNumber;
    private Double valueNumber;
    private Long valueInteger;
    private DocumentSelectionMarkState valueSelectionMark;
    private DocumentSignatureType valueSignature;
    private String valueCountryRegion;
    private CurrencyValue valueCurrency;
    private AddressValue valueAddress;
    private Boolean valueBoolean;
    private List<String> valueSelectionGroup;
    private String content;
    private List<BoundingRegion> boundingRegions;
    private List<DocumentSpan> spans;
    private Double confidence;
    private List<DocumentField> valueList;
    private Map<String, DocumentField> valueMap;

    private DocumentField(DocumentFieldType type) {
        this.type = type;
    }

    public DocumentFieldType getType() {
        return this.type;
    }

    public String getValueString() {
        return this.valueString;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public String getValueTime() {
        return this.valueTime;
    }

    public String getValuePhoneNumber() {
        return this.valuePhoneNumber;
    }

    public Double getValueNumber() {
        return this.valueNumber;
    }

    public Long getValueInteger() {
        return this.valueInteger;
    }

    public DocumentSelectionMarkState getValueSelectionMark() {
        return this.valueSelectionMark;
    }

    public DocumentSignatureType getValueSignature() {
        return this.valueSignature;
    }

    public String getValueCountryRegion() {
        return this.valueCountryRegion;
    }

    public CurrencyValue getValueCurrency() {
        return this.valueCurrency;
    }

    public AddressValue getValueAddress() {
        return this.valueAddress;
    }

    public Boolean isValueBoolean() {
        return this.valueBoolean;
    }

    public List<String> getValueSelectionGroup() {
        return this.valueSelectionGroup;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valueString", this.valueString);
        jsonWriter.writeStringField("valueDate", Objects.toString(this.valueDate, null));
        jsonWriter.writeStringField("valueTime", this.valueTime);
        jsonWriter.writeStringField("valuePhoneNumber", this.valuePhoneNumber);
        jsonWriter.writeNumberField("valueNumber", (Number)this.valueNumber);
        jsonWriter.writeNumberField("valueInteger", (Number)this.valueInteger);
        jsonWriter.writeStringField("valueSelectionMark", this.valueSelectionMark == null ? null : this.valueSelectionMark.toString());
        jsonWriter.writeStringField("valueSignature", this.valueSignature == null ? null : this.valueSignature.toString());
        jsonWriter.writeStringField("valueCountryRegion", this.valueCountryRegion);
        jsonWriter.writeArrayField("valueArray", this.valueList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("valueObject", this.valueMap, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("valueCurrency", (JsonSerializable)this.valueCurrency);
        jsonWriter.writeJsonField("valueAddress", (JsonSerializable)this.valueAddress);
        jsonWriter.writeBooleanField("valueBoolean", this.valueBoolean);
        jsonWriter.writeArrayField("valueSelectionGroup", this.valueSelectionGroup, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("confidence", (Number)this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DocumentField fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentField)jsonReader.readObject(reader -> {
            DocumentFieldType type = null;
            String valueString = null;
            LocalDate valueDate = null;
            String valueTime = null;
            String valuePhoneNumber = null;
            Double valueNumber = null;
            Long valueInteger = null;
            DocumentSelectionMarkState valueSelectionMark = null;
            DocumentSignatureType valueSignature = null;
            String valueCountryRegion = null;
            List valueList = null;
            Map valueMap = null;
            CurrencyValue valueCurrency = null;
            AddressValue valueAddress = null;
            Boolean valueBoolean = null;
            List valueSelectionGroup = null;
            String content = null;
            List boundingRegions = null;
            List spans = null;
            Double confidence = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = DocumentFieldType.fromString(reader.getString());
                    continue;
                }
                if ("valueString".equals(fieldName)) {
                    valueString = reader.getString();
                    continue;
                }
                if ("valueDate".equals(fieldName)) {
                    valueDate = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("valueTime".equals(fieldName)) {
                    valueTime = reader.getString();
                    continue;
                }
                if ("valuePhoneNumber".equals(fieldName)) {
                    valuePhoneNumber = reader.getString();
                    continue;
                }
                if ("valueNumber".equals(fieldName)) {
                    valueNumber = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("valueInteger".equals(fieldName)) {
                    valueInteger = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("valueSelectionMark".equals(fieldName)) {
                    valueSelectionMark = DocumentSelectionMarkState.fromString(reader.getString());
                    continue;
                }
                if ("valueSignature".equals(fieldName)) {
                    valueSignature = DocumentSignatureType.fromString(reader.getString());
                    continue;
                }
                if ("valueCountryRegion".equals(fieldName)) {
                    valueCountryRegion = reader.getString();
                    continue;
                }
                if ("valueArray".equals(fieldName)) {
                    valueList = reader.readArray(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                if ("valueObject".equals(fieldName)) {
                    valueMap = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                if ("valueCurrency".equals(fieldName)) {
                    valueCurrency = CurrencyValue.fromJson(reader);
                    continue;
                }
                if ("valueAddress".equals(fieldName)) {
                    valueAddress = AddressValue.fromJson(reader);
                    continue;
                }
                if ("valueBoolean".equals(fieldName)) {
                    valueBoolean = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("valueSelectionGroup".equals(fieldName)) {
                    valueSelectionGroup = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            DocumentField deserializedDocumentField = new DocumentField(type);
            deserializedDocumentField.valueString = valueString;
            deserializedDocumentField.valueDate = valueDate;
            deserializedDocumentField.valueTime = valueTime;
            deserializedDocumentField.valuePhoneNumber = valuePhoneNumber;
            deserializedDocumentField.valueNumber = valueNumber;
            deserializedDocumentField.valueInteger = valueInteger;
            deserializedDocumentField.valueSelectionMark = valueSelectionMark;
            deserializedDocumentField.valueSignature = valueSignature;
            deserializedDocumentField.valueCountryRegion = valueCountryRegion;
            deserializedDocumentField.valueList = valueList;
            deserializedDocumentField.valueMap = valueMap;
            deserializedDocumentField.valueCurrency = valueCurrency;
            deserializedDocumentField.valueAddress = valueAddress;
            deserializedDocumentField.valueBoolean = valueBoolean;
            deserializedDocumentField.valueSelectionGroup = valueSelectionGroup;
            deserializedDocumentField.content = content;
            deserializedDocumentField.boundingRegions = boundingRegions;
            deserializedDocumentField.spans = spans;
            deserializedDocumentField.confidence = confidence;
            return deserializedDocumentField;
        });
    }

    public List<DocumentField> getValueList() {
        return this.valueList;
    }

    public Map<String, DocumentField> getValueMap() {
        return this.valueMap;
    }
}

