// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Document model info.
 */
@Immutable
public final class DocumentModelDetails implements JsonSerializable<DocumentModelDetails> {

    /*
     * Unique document model name.
     */
    @Generated
    private String modelId;

    /*
     * Document model description.
     */
    @Generated
    private String description;

    /*
     * Date and time (UTC) when the document model was created.
     */
    @Generated
    private OffsetDateTime createdOn;

    /*
     * Date and time (UTC) when the document model will expire.
     */
    @Generated
    private OffsetDateTime expiresOn;

    /*
     * Date and time (UTC) when the document model was last modified.
     */
    @Generated
    private OffsetDateTime modifiedOn;

    /*
     * API version used to create this document model.
     */
    @Generated
    private String apiVersion;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Custom document model build mode.
     */
    @Generated
    private DocumentBuildMode buildMode;

    /*
     * Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /*
     * For composed models, the custom classifier to split and classify the input file.
     */
    @Generated
    private String classifierId;

    /*
     * For composed models, the file splitting behavior.
     */
    @Generated
    private SplitMode split;

    /*
     * Supported document types.
     */
    @Generated
    private Map<String, DocumentTypeDetails> documentTypes;

    /*
     * List of warnings encountered while building the model.
     */
    @Generated
    private List<DocumentIntelligenceWarning> warnings;

    /*
     * Number of V100-equivalent GPU hours consumed for model training.
     */
    @Generated
    private Double trainingHours;

    /**
     * Creates an instance of DocumentModelDetails class.
     */
    @Generated
    private DocumentModelDetails() {
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the createdOn property: Date and time (UTC) when the document model was created.
     *
     * @return the createdOn value.
     */
    @Generated
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    /**
     * Get the expiresOn property: Date and time (UTC) when the document model will expire.
     *
     * @return the expiresOn value.
     */
    @Generated
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * Get the modifiedOn property: Date and time (UTC) when the document model was last modified.
     *
     * @return the modifiedOn value.
     */
    @Generated
    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    /**
     * Get the apiVersion property: API version used to create this document model.
     *
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     *
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Get the classifierId property: For composed models, the custom classifier to split and classify the input file.
     *
     * @return the classifierId value.
     */
    @Generated
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the split property: For composed models, the file splitting behavior.
     *
     * @return the split value.
     */
    @Generated
    public SplitMode getSplit() {
        return this.split;
    }

    /**
     * Get the documentTypes property: Supported document types.
     *
     * @return the documentTypes value.
     */
    @Generated
    public Map<String, DocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    /**
     * Get the warnings property: List of warnings encountered while building the model.
     *
     * @return the warnings value.
     */
    @Generated
    public List<DocumentIntelligenceWarning> getWarnings() {
        return this.warnings;
    }

    /**
     * Get the trainingHours property: Number of V100-equivalent GPU hours consumed for model training.
     *
     * @return the trainingHours value.
     */
    @Generated
    public Double getTrainingHours() {
        return this.trainingHours;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeStringField("split", this.split == null ? null : this.split.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentModelDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentModelDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentModelDetails.
     */
    @Generated
    public static DocumentModelDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentModelDetails deserializedDocumentModelDetails = new DocumentModelDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    deserializedDocumentModelDetails.modelId = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedDocumentModelDetails.description = reader.getString();
                } else if ("expirationDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("modifiedDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.modifiedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedDocumentModelDetails.apiVersion = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDocumentModelDetails.tags = tags;
                } else if ("buildMode".equals(fieldName)) {
                    deserializedDocumentModelDetails.buildMode = DocumentBuildMode.fromString(reader.getString());
                } else if ("azureBlobSource".equals(fieldName)) {
                    deserializedDocumentModelDetails.azureBlobSource = AzureBlobContentSource.fromJson(reader);
                } else if ("azureBlobFileListSource".equals(fieldName)) {
                    deserializedDocumentModelDetails.azureBlobFileListSource
                        = AzureBlobFileListContentSource.fromJson(reader);
                } else if ("classifierId".equals(fieldName)) {
                    deserializedDocumentModelDetails.classifierId = reader.getString();
                } else if ("split".equals(fieldName)) {
                    deserializedDocumentModelDetails.split = SplitMode.fromString(reader.getString());
                } else if ("docTypes".equals(fieldName)) {
                    Map<String, DocumentTypeDetails> documentTypes
                        = reader.readMap(reader1 -> DocumentTypeDetails.fromJson(reader1));
                    deserializedDocumentModelDetails.documentTypes = documentTypes;
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentIntelligenceWarning> warnings
                        = reader.readArray(reader1 -> DocumentIntelligenceWarning.fromJson(reader1));
                    deserializedDocumentModelDetails.warnings = warnings;
                } else if ("trainingHours".equals(fieldName)) {
                    deserializedDocumentModelDetails.trainingHours = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedDocumentModelDetails;
        });
    }
}
