/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.Error;
import com.azure.ai.documentintelligence.models.OperationDetails;
import com.azure.ai.documentintelligence.models.OperationKind;
import com.azure.ai.documentintelligence.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class DocumentModelCopyToOperationDetails
extends OperationDetails {
    private OperationKind kind = OperationKind.DOCUMENT_MODEL_COPY_TO;
    private DocumentModelDetails result;
    private Error error;
    private Map<String, String> tags;
    private String apiVersion;
    private Integer percentCompleted;

    private DocumentModelCopyToOperationDetails(OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime, String resourceLocation) {
        super(status, createdDateTime, lastUpdatedDateTime, resourceLocation);
    }

    @Override
    public OperationKind getKind() {
        return this.kind;
    }

    public DocumentModelDetails getResult() {
        return this.result;
    }

    @Override
    public Error getError() {
        return this.error;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("createdDateTime", this.getCreatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreatedDateTime()));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.getLastUpdatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdatedDateTime()));
        jsonWriter.writeStringField("resourceLocation", this.getResourceLocation());
        jsonWriter.writeNumberField("percentCompleted", (Number)this.getPercentCompleted());
        jsonWriter.writeStringField("apiVersion", this.getApiVersion());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("result", (JsonSerializable)this.result);
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelCopyToOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelCopyToOperationDetails)jsonReader.readObject(reader -> {
            String operationId = null;
            OperationStatus status = null;
            OffsetDateTime createdDateTime = null;
            OffsetDateTime lastUpdatedDateTime = null;
            String resourceLocation = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            Error error = null;
            OperationKind kind = OperationKind.DOCUMENT_MODEL_COPY_TO;
            DocumentModelDetails result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = DocumentModelDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DocumentModelCopyToOperationDetails deserializedDocumentModelCopyToOperationDetails = new DocumentModelCopyToOperationDetails(status, createdDateTime, lastUpdatedDateTime, resourceLocation);
            deserializedDocumentModelCopyToOperationDetails.setOperationId(operationId);
            deserializedDocumentModelCopyToOperationDetails.percentCompleted = percentCompleted;
            deserializedDocumentModelCopyToOperationDetails.apiVersion = apiVersion;
            deserializedDocumentModelCopyToOperationDetails.tags = tags;
            deserializedDocumentModelCopyToOperationDetails.error = error;
            deserializedDocumentModelCopyToOperationDetails.kind = kind;
            deserializedDocumentModelCopyToOperationDetails.result = result;
            return deserializedDocumentModelCopyToOperationDetails;
        });
    }
}

