/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CopyAuthorization
implements JsonSerializable<CopyAuthorization> {
    private final String targetResourceId;
    private final String targetResourceRegion;
    private final String targetModelId;
    private final String targetModelLocation;
    private final String accessToken;
    private final OffsetDateTime expirationDateTime;

    public CopyAuthorization(String targetResourceId, String targetResourceRegion, String targetModelId, String targetModelLocation, String accessToken, OffsetDateTime expirationDateTime) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetModelId = targetModelId;
        this.targetModelLocation = targetModelLocation;
        this.accessToken = accessToken;
        this.expirationDateTime = expirationDateTime;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    public String getTargetModelId() {
        return this.targetModelId;
    }

    public String getTargetModelLocation() {
        return this.targetModelLocation;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeStringField("targetModelId", this.targetModelId);
        jsonWriter.writeStringField("targetModelLocation", this.targetModelLocation);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        return jsonWriter.writeEndObject();
    }

    public static CopyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (CopyAuthorization)jsonReader.readObject(reader -> {
            String targetResourceId = null;
            String targetResourceRegion = null;
            String targetModelId = null;
            String targetModelLocation = null;
            String accessToken = null;
            OffsetDateTime expirationDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    targetResourceRegion = reader.getString();
                    continue;
                }
                if ("targetModelId".equals(fieldName)) {
                    targetModelId = reader.getString();
                    continue;
                }
                if ("targetModelLocation".equals(fieldName)) {
                    targetModelLocation = reader.getString();
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    accessToken = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new CopyAuthorization(targetResourceId, targetResourceRegion, targetModelId, targetModelLocation, accessToken, expirationDateTime);
        });
    }
}

