/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceAdministrationClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceAdministrationClientImpl;
import com.azure.ai.documentintelligence.models.AuthorizeCopyRequest;
import com.azure.ai.documentintelligence.models.BuildDocumentClassifierRequest;
import com.azure.ai.documentintelligence.models.BuildDocumentModelRequest;
import com.azure.ai.documentintelligence.models.ComposeDocumentModelRequest;
import com.azure.ai.documentintelligence.models.CopyAuthorization;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.OperationDetails;
import com.azure.ai.documentintelligence.models.ResourceDetails;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentIntelligenceAdministrationClientBuilder.class, isAsync=true)
public final class DocumentIntelligenceAdministrationAsyncClient {
    private final DocumentIntelligenceAdministrationClientImpl serviceClient;

    DocumentIntelligenceAdministrationAsyncClient(DocumentIntelligenceAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildDocumentModelAsync(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginComposeModelAsync(composeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeModelCopyWithResponseAsync(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyModelToAsync(modelId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listModels(RequestOptions requestOptions) {
        return this.serviceClient.listModelsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getResourceInfoWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getResourceInfoWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildClassifierAsync(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.getClassifierWithResponseAsync(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listClassifiers(RequestOptions requestOptions) {
        return this.serviceClient.listClassifiersAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.deleteClassifierWithResponseAsync(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModel(BuildDocumentModelRequest buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildDocumentModelWithModelAsync(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModel(ComposeDocumentModelRequest composeRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginComposeModelWithModelAsync(BinaryData.fromObject((Object)composeRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.authorizeModelCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (CopyAuthorization)protocolMethodData.toObject(CopyAuthorization.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyModelToWithModelAsync(modelId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentModelDetails)protocolMethodData.toObject(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelDetails> listModels() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listModels(requestOptions);
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationToken).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DocumentModelDetails)protocolMethodData.toObject(DocumentModelDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceInfo() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getResourceInfoWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ResourceDetails)protocolMethodData.toObject(ResourceDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperation(String operationId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getOperationWithResponse(operationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (OperationDetails)protocolMethodData.toObject(OperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationDetails> listOperations() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listOperations(requestOptions);
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationToken).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (OperationDetails)protocolMethodData.toObject(OperationDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifier(BuildDocumentClassifierRequest buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildClassifierWithModelAsync(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassifierWithResponse(classifierId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentClassifierDetails)protocolMethodData.toObject(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiers() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listClassifiers(requestOptions);
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationToken).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DocumentClassifierDetails)protocolMethodData.toObject(DocumentClassifierDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteClassifierWithResponse(classifierId, requestOptions).flatMap(FluxUtil::toMono);
    }
}

