/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DocumentModelAdministrationClientImpl {
    private final DocumentModelAdministrationClientService service;
    private final String endpoint;
    private final DocumentIntelligenceServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public DocumentIntelligenceServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DocumentModelAdministrationClientImpl(String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentModelAdministrationClientImpl(HttpPipeline httpPipeline, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentModelAdministrationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (DocumentModelAdministrationClientService)RestProxy.create(DocumentModelAdministrationClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> buildDocumentModelWithResponseAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.buildDocumentModel(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", buildRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> buildDocumentModelWithResponse(BinaryData buildRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.buildDocumentModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", buildRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponseAsync(buildRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponse(buildRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModelWithModelAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponseAsync(buildRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelBuildOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModelWithModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponse(buildRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelBuildOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> composeModelWithResponseAsync(BinaryData composeRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.composeModel(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", composeRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> composeModelWithResponse(BinaryData composeRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.composeModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", composeRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(BinaryData composeRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponseAsync(composeRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponse(composeRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModelWithModelAsync(BinaryData composeRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponseAsync(composeRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelComposeOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModelWithModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponse(composeRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelComposeOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeModelCopyWithResponseAsync(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.authorizeModelCopy(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", authorizeCopyRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.authorizeModelCopySync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", authorizeCopyRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> copyModelToWithResponseAsync(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.copyModelTo(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", copyToRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> copyModelToWithResponse(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.copyModelToSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", copyToRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponse(modelId, copyToRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelToWithModelAsync(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelCopyToOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelToWithModel(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponse(modelId, copyToRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentModelCopyToOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getModel(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listModelsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listModels(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listModelsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listModelsSinglePageAsync(requestOptions), nextLink -> this.listModelsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listModelsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listModelsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listModels(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listModelsSinglePage(requestOptions), nextLink -> this.listModelsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteModel(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getResourceInfoWithResponseAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceInfo(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getResourceInfoWithResponse(RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getResourceInfoSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponseAsync(String operationId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperation(this.getEndpoint(), this.getServiceVersion().getVersion(), operationId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getOperationSync(this.getEndpoint(), this.getServiceVersion().getVersion(), operationId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listOperationsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperations(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(requestOptions), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listOperationsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listOperationsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listOperationsSinglePage(requestOptions), nextLink -> this.listOperationsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> buildClassifierWithResponseAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.buildClassifier(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", buildRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> buildClassifierWithResponse(BinaryData buildRequest, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.buildClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", buildRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponseAsync(buildRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponse(buildRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifierWithModelAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponseAsync(buildRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentClassifierBuildOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifierWithModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildClassifierWithResponse(buildRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DocumentClassifierBuildOperationDetails.class), (TypeReference)TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassifierWithResponseAsync(String classifierId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getClassifier(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listClassifiersSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listClassifiers(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listClassifiersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listClassifiersSinglePageAsync(requestOptions), nextLink -> this.listClassifiersNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listClassifiersSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listClassifiersSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listClassifiers(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listClassifiersSinglePage(requestOptions), nextLink -> this.listClassifiersNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteClassifier(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listModelsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listModelsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listModelsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listModelsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listOperationsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listOperationsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listOperationsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listClassifiersNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listClassifiersNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listClassifiersNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listClassifiersNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}/documentintelligence")
    @ServiceInterface(name="DocumentModelAdminis")
    public static interface DocumentModelAdministrationClientService {
        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> buildDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> buildDocumentModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> composeModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> composeModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> authorizeModelCopy(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> authorizeModelCopySync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> copyModelTo(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> copyModelToSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listModels(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listModelsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getResourceInfo(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getResourceInfoSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getOperation(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="operationId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getOperationSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="operationId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listOperations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listOperationsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/documentClassifiers:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> buildClassifier(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Post(value="/documentClassifiers:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> buildClassifierSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, @BodyParam(value="application/json") BinaryData var4, RequestOptions var5, Context var6);

        @Get(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getClassifier(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getClassifierSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/documentClassifiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listClassifiers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/documentClassifiers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listClassifiersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Delete(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteClassifier(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/documentClassifiers/{classifierId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteClassifierSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="accept") String var4, RequestOptions var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listModelsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listOperationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listClassifiersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listClassifiersNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept") String var3, RequestOptions var4, Context var5);
    }
}

