// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object representing the detected language for a given text span.
 */
@Immutable
public final class DocumentLanguage {
    /*
     * Detected language. Value may an ISO 639-1 language code (ex. "en", "fr")
     * or BCP 47 language tag (ex. "zh-Hans").
     */
    @Generated
    @JsonProperty(value = "locale")
    private String locale;

    /*
     * Location of the text elements in the concatenated content the language applies
     * to.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Confidence of correctly identifying the language.
     */
    @Generated
    @JsonProperty(value = "confidence")
    private double confidence;

    /**
     * Creates an instance of DocumentLanguage class.
     * 
     * @param locale the locale value to set.
     * @param spans the spans value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DocumentLanguage(@JsonProperty(value = "locale") String locale,
        @JsonProperty(value = "spans") List<DocumentSpan> spans,
        @JsonProperty(value = "confidence") double confidence) {
        this.locale = locale;
        this.spans = spans;
        this.confidence = confidence;
    }

    /**
     * Get the locale property: Detected language. Value may an ISO 639-1 language code (ex. "en", "fr")
     * or BCP 47 language tag (ex. "zh-Hans").
     * 
     * @return the locale value.
     */
    @Generated
    public String getLocale() {
        return this.locale;
    }

    /**
     * Get the spans property: Location of the text elements in the concatenated content the language applies
     * to.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the confidence property: Confidence of correctly identifying the language.
     * 
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
