// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Request body to create a composed document model from component document models.
 */
@Fluent
public final class ComposeDocumentModelRequest {
    /*
     * Unique document model name.
     */
    @Generated
    @JsonProperty(value = "modelId")
    private String modelId;

    /*
     * Document model description.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * List of component document models to compose.
     */
    @Generated
    @JsonProperty(value = "componentModels")
    private List<ComponentDocumentModelDetails> componentModels;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Creates an instance of ComposeDocumentModelRequest class.
     * 
     * @param modelId the modelId value to set.
     * @param componentModels the componentModels value to set.
     */
    @Generated
    @JsonCreator
    public ComposeDocumentModelRequest(@JsonProperty(value = "modelId") String modelId,
        @JsonProperty(value = "componentModels") List<ComponentDocumentModelDetails> componentModels) {
        this.modelId = modelId;
        this.componentModels = componentModels;
    }

    /**
     * Get the modelId property: Unique document model name.
     * 
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     * 
     * @param description the description value to set.
     * @return the ComposeDocumentModelRequest object itself.
     */
    @Generated
    public ComposeDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the componentModels property: List of component document models to compose.
     * 
     * @return the componentModels value.
     */
    @Generated
    public List<ComponentDocumentModelDetails> getComponentModels() {
        return this.componentModels;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @param tags the tags value to set.
     * @return the ComposeDocumentModelRequest object itself.
     */
    @Generated
    public ComposeDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }
}
