// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Request body to build a new custom document classifier.
 */
@Fluent
public final class BuildDocumentClassifierRequest {
    /*
     * Unique document classifier name.
     */
    @Generated
    @JsonProperty(value = "classifierId")
    private String classifierId;

    /*
     * Document classifier description.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * List of document types to classify against.
     */
    @Generated
    @JsonProperty(value = "docTypes")
    private Map<String, ClassifierDocumentTypeDetails> docTypes;

    /**
     * Creates an instance of BuildDocumentClassifierRequest class.
     * 
     * @param classifierId the classifierId value to set.
     * @param docTypes the docTypes value to set.
     */
    @Generated
    @JsonCreator
    public BuildDocumentClassifierRequest(@JsonProperty(value = "classifierId") String classifierId,
        @JsonProperty(value = "docTypes") Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.classifierId = classifierId;
        this.docTypes = docTypes;
    }

    /**
     * Get the classifierId property: Unique document classifier name.
     * 
     * @return the classifierId value.
     */
    @Generated
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the description property: Document classifier description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document classifier description.
     * 
     * @param description the description value to set.
     * @return the BuildDocumentClassifierRequest object itself.
     */
    @Generated
    public BuildDocumentClassifierRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the docTypes property: List of document types to classify against.
     * 
     * @return the docTypes value.
     */
    @Generated
    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }
}
