// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Document analysis parameters.
 */
@Fluent
public final class AnalyzeDocumentRequest {
    /*
     * Document URL to analyze. Either urlSource or base64Source must be specified.
     */
    @Generated
    @JsonProperty(value = "urlSource")
    private String urlSource;

    /*
     * Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     */
    @Generated
    @JsonProperty(value = "base64Source")
    private byte[] base64Source;

    /**
     * Creates an instance of AnalyzeDocumentRequest class.
     */
    @Generated
    public AnalyzeDocumentRequest() {
    }

    /**
     * Get the urlSource property: Document URL to analyze. Either urlSource or base64Source must be specified.
     * 
     * @return the urlSource value.
     */
    @Generated
    public String getUrlSource() {
        return this.urlSource;
    }

    /**
     * Set the urlSource property: Document URL to analyze. Either urlSource or base64Source must be specified.
     * 
     * @param urlSource the urlSource value to set.
     * @return the AnalyzeDocumentRequest object itself.
     */
    @Generated
    public AnalyzeDocumentRequest setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    /**
     * Get the base64Source property: Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     * 
     * @return the base64Source value.
     */
    @Generated
    public byte[] getBase64Source() {
        return CoreUtils.clone(this.base64Source);
    }

    /**
     * Set the base64Source property: Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     * 
     * @param base64Source the base64Source value to set.
     * @return the AnalyzeDocumentRequest object itself.
     */
    @Generated
    public AnalyzeDocumentRequest setBase64Source(byte[] base64Source) {
        this.base64Source = CoreUtils.clone(base64Source);
        return this;
    }
}
