/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.utils;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Trace;
import com.microsoft.dl.BuildInfo;
import com.microsoft.dl.utils.Log;

public final class Systrace {
    private static final Section[] SECTIONS = Section.values();
    private static final boolean IS_ENABLED = BuildInfo.FLAVOUR != BuildInfo.Flavour.RELEASE && Build.VERSION.SDK_INT >= 18;

    private Systrace() {
    }

    @TargetApi(value=18)
    public static void begin(Section section) {
        if (IS_ENABLED) {
            Trace.beginSection((String)section.toString());
        }
    }

    public static void begin(int key) {
        block2: {
            try {
                Systrace.begin(SECTIONS[key]);
            }
            catch (RuntimeException e) {
                if (!Log.isLoggable("Common", 6)) break block2;
                Log.e("Common", "Exception caught", e);
            }
        }
    }

    @TargetApi(value=18)
    public static void end() {
        block3: {
            try {
                if (IS_ENABLED) {
                    Trace.endSection();
                }
            }
            catch (RuntimeException e) {
                if (!Log.isLoggable("Common", 6)) break block3;
                Log.e("Common", "Exception caught", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Section {
        CaptureVideo,
        DeliverVideo,
        IssueFakeVideoFrame,
        ReadFakeVideoFrame,
        CopyFakeVideoFrame,
        PreviewFakeVideoFrame;

    }
}

