/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.utils;

public class Blossom {
    private final int bits;
    private long bloom;

    public Blossom(int bits) {
        this.bits = bits;
    }

    private static int knuth(int value) {
        return value * (value + 3) % 64;
    }

    private long getFamily(int value) {
        int enough = value + this.bits;
        long family = 0L;
        while (value < enough) {
            family |= (long)(1 << Blossom.knuth(value++));
        }
        return family;
    }

    private static int fold(long value) {
        return (int)(value ^ value >>> 32);
    }

    public void put(int value) {
        this.bloom |= this.getFamily(value);
    }

    public void put(long value) {
        this.put(Blossom.fold(value));
    }

    public void put(Object obj) {
        this.put(obj.hashCode());
    }

    public boolean mayHave(int value) {
        long family = this.getFamily(value);
        return (this.bloom & family) == family;
    }

    public boolean mayHave(long value) {
        return this.mayHave(Blossom.fold(value));
    }

    public boolean mayHave(Object obj) {
        return this.mayHave(obj.hashCode());
    }

    public void clear() {
        this.bloom = 0L;
    }
}

