/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.control;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import com.skype.android.video.hw.codec.encoder.AbstractVideoEncoder;
import com.skype.android.video.hw.codec.encoder.control.AbstractVideoEncoderControl;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.Log;
import java.util.Locale;

public final class VideoEncoderControlQcAfterNExtension
extends AbstractVideoEncoderControl {
    private final Bundle frameParams = new Bundle();
    private final MediaCodec mediaCodec;
    private int curNumTemporalLayers = 1;
    private int prevNumTemporalLayers = 1;
    private String extPrefix;
    private final String simpleClassName = this.getClass().getSimpleName();

    public VideoEncoderControlQcAfterNExtension(MediaCodec mediaCodec) {
        super(mediaCodec, null);
        this.mediaCodec = mediaCodec;
        this.extPrefix = mediaCodec.getCodecInfo().getName().toLowerCase(Locale.ROOT).contains("qcom") ? "vendor.qti" : "vendor.rtc";
    }

    public void setRcFrameRate(float fps) throws AbstractVideoEncoder.APINotImplementedException {
    }

    public void setQp(int qp) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt(this.extPrefix + "-ext-enc-frame-qp.value", qp);
    }

    public void setNumTempLayers(int numTempLayers) throws AbstractVideoEncoder.APINotImplementedException {
        Log.d("SLIQ", "setNumTempLayers " + numTempLayers);
        this.frameParams.putString("ts-schema", "android.generic." + numTempLayers);
        this.curNumTemporalLayers = numTempLayers;
    }

    public void setBaseLayerPID(int baseLayerPID) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt(this.extPrefix + "-ext-enc-base-layer-pid.value", baseLayerPID);
    }

    public void markLtrFrame(int longTermFrameIdx) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt(this.extPrefix + "-ext-enc-ltr.mark-frame", longTermFrameIdx);
    }

    public void useLTRFrame(int useLTRFrameIdxBitMap) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt(this.extPrefix + "-ext-enc-ltr.use-frame", useLTRFrameIdxBitMap);
    }

    public void doConfigureMediaFormat(MediaFormat mediaFormat, VideoFormat format) {
        int maxNumTemporalLayers;
        super.doConfigureMediaFormat(mediaFormat, format);
        Log.i("SLIQ", "doConfigureMediaFormat  " + format.toString());
        mediaFormat.setInteger(this.extPrefix + "-ext-enc-low-latency.enable", 1);
        mediaFormat.setInteger("prepend-sps-pps-to-idr-frames", 1);
        mediaFormat.setInteger(this.extPrefix + "-ext-enc-app-input-control.enable", 1);
        mediaFormat.setInteger(this.extPrefix + "-ext-enc-custom-profile-level.level", format.getLevel().getOmxValue().intValue());
        int profile = format.getProfile().getOmxValue();
        if (Build.VERSION.SDK_INT < 28) {
            mediaFormat.setInteger("bitrate-mode", 0);
        } else {
            mediaFormat.setInteger(this.extPrefix + "-ext-enc-bitrate-mode.value", 0);
        }
        mediaFormat.setInteger("profile", profile);
        mediaFormat.setInteger(this.extPrefix + "-ext-enc-custom-profile-level.profile", profile);
        int numSlices = Math.min(Math.max(format.getMinNumSlices(), 1), 15);
        int widthMB = format.getResolution().getWidth() + 15 >> 4;
        int heightMB = format.getResolution().getHeight() + 15 >> 4;
        int sliceSize = (widthMB * heightMB + numSlices - 1) / numSlices;
        if (sliceSize > 1) {
            mediaFormat.setInteger(this.extPrefix + "-ext-enc-slice.spacing", sliceSize);
        } else {
            mediaFormat.setInteger(this.extPrefix + "-ext-enc-slice.spacing", 0);
        }
        int operatingfps = CodecUtils.getEncoderOperatingFpsFromNative();
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + " operatingfps " + operatingfps);
        }
        if (operatingfps != 0) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + " Setting KEY_OPERATING_RATE to " + operatingfps);
            }
            mediaFormat.setInteger("operating-rate", operatingfps);
        }
        this.curNumTemporalLayers = format.getNumLayers();
        this.prevNumTemporalLayers = maxNumTemporalLayers = format.getNumLayers() > 1 ? format.getNumLayers() : (format.getSvcAlways() ? 2 : 0);
        if (this.curNumTemporalLayers > 1 || format.getSvcAlways()) {
            mediaFormat.setString("ts-schema", "android.generic." + maxNumTemporalLayers);
        }
        int numLtrFrames = Math.max(format.getRefCount(), 1) - 1;
        mediaFormat.setInteger(this.extPrefix + "-ext-enc-ltr-count.num-ltr-frames", numLtrFrames);
    }

    public void cleanFrameParams() {
        this.frameParams.clear();
        if (this.prevNumTemporalLayers != this.curNumTemporalLayers) {
            this.frameParams.putString("ts-schema", "android.generic." + this.curNumTemporalLayers);
            this.prevNumTemporalLayers = this.curNumTemporalLayers;
        }
    }

    public void markParamsTimestamp(long timestampMs) {
        Log.d("SLIQ", this.simpleClassName + "set " + this.extPrefix + "-ext-enc-input-trigger.timestamp " + timestampMs * 1000L + " us");
        this.frameParams.putLong(this.extPrefix + "-ext-enc-input-trigger.timestamp", timestampMs * 1000L);
    }

    public void configureFrameParams() {
        this.prevNumTemporalLayers = this.curNumTemporalLayers;
        this.mediaCodec.setParameters(this.frameParams);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + ": Setting " + this.frameParams + " on " + this.mediaCodec);
        }
    }
}

