/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera;

import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.AbstractVideoEncoder;
import com.skype.android.video.hw.codec.encoder.camera.SurfaceObserver;
import com.skype.android.video.hw.format.ColorFormat;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.Log;
import java.lang.ref.WeakReference;

public class VideoTextureEncoder
extends AbstractVideoEncoder {
    private Surface inputSurface;
    private WeakReference<SurfaceObserver> weakRefSurfaceObserver;
    private final String simpleClassName = this.getClass().getSimpleName();

    public VideoTextureEncoder(String codecName, SurfaceObserver surfaceObserver) {
        super(codecName);
        this.weakRefSurfaceObserver = new WeakReference<SurfaceObserver>(surfaceObserver);
    }

    public void configure(Object userData, VideoFormat videoFormat, boolean checkHwApiVersioning) {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (!videoFormat.getColorFormat().equals(ColorFormat.SURFACE)) {
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": " + ColorFormat.SURFACE + " color format is expected");
            }
            videoFormat.setColorFormat(ColorFormat.SURFACE);
        }
        SurfaceObserver surfaceObserver = (SurfaceObserver)this.weakRefSurfaceObserver.get();
        super.configure(surfaceObserver, videoFormat, checkHwApiVersioning);
        this.inputSurface = this.mediaCodec.createInputSurface();
        if (surfaceObserver != null) {
            Resolution inputResolution = videoFormat.getOrgResolution();
            if (inputResolution.getWidth() == 0 || inputResolution.getHeight() == 0) {
                inputResolution = videoFormat.getResolution();
            }
            surfaceObserver.attachSurface(this.inputSurface, inputResolution);
        } else {
            this.inputSurface.release();
            this.inputSurface = null;
        }
    }

    public void close() {
        SurfaceObserver surfaceObserver;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if ((surfaceObserver = (SurfaceObserver)this.weakRefSurfaceObserver.get()) != null) {
            surfaceObserver.detachSurface();
        } else if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        super.close();
    }

    public OutputFrame encode(long timeoutUs) {
        return super.drainCodec(timeoutUs, false);
    }
}

