/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx;

import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.skype.android.jipc.omx.CallRouter;
import com.skype.android.jipc.omx.NotMyNodeException;
import com.skype.android.jipc.omx.message.OmxMessage;
import com.skype.android.video.hw.utils.Blossom;
import java.util.concurrent.atomic.AtomicInteger;

public class OmxObserver
extends Binder {
    private final OmxMessage outMessage = new OmxMessage();
    private final AtomicInteger refs = new AtomicInteger();
    private final Blossom filter = new Blossom(3);
    private final CallRouter callRouter;
    private OnMessageListener listener;

    OmxObserver(CallRouter router) {
        this.callRouter = router;
        this.attachInterface(new IInterface(){

            public IBinder asBinder() {
                return OmxObserver.this;
            }
        }, "android.hardware.IOMXObserver");
    }

    public void setListener(OnMessageListener listener) {
        this.listener = listener;
    }

    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == this.callRouter.onMessage().code()) {
            if (this.listener != null) {
                int nodeId = data.readInt();
                if (Build.VERSION.SDK_INT >= 23) {
                    int fence;
                    while ((fence = data.readInt()) >= 0) {
                        this.outMessage.fill(nodeId, fence != 0, data);
                        this.listener.onMessage(this.outMessage);
                    }
                } else {
                    this.outMessage.fill(nodeId, data);
                    this.listener.onMessage(this.outMessage);
                }
            }
            return true;
        }
        return super.onTransact(code, data, reply, flags);
    }

    public void lock() {
        this.refs.incrementAndGet();
    }

    public void markNodeId(int nodeId) {
        this.filter.put(nodeId);
    }

    public void unlock() {
        if (this.refs.decrementAndGet() == 0) {
            this.filter.clear();
        }
    }

    public void ensureNodeId(int nodeId) {
        if (!this.filter.mayHave(nodeId)) {
            throw new NotMyNodeException(nodeId);
        }
    }

    public static interface OnMessageListener {
        public void onMessage(OmxMessage var1);
    }
}

