/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc;

import android.os.IBinder;
import com.skype.android.jipc.LoopholeClosedException;
import java.lang.reflect.Method;

public class Locator {
    final Class<?> serviceManagerClass;
    final Method method;
    private static volatile Locator instance;

    private Locator() {
        try {
            this.serviceManagerClass = Class.forName("android.os.ServiceManager");
            this.method = this.serviceManagerClass.getDeclaredMethod("getService", String.class);
            this.method.setAccessible(true);
        }
        catch (Exception e) {
            throw new LoopholeClosedException(e);
        }
    }

    public static Locator getInstance() {
        if (instance == null) {
            instance = new Locator();
        }
        return instance;
    }

    public IBinder locate(String serviceName) {
        try {
            return (IBinder)this.method.invoke(null, serviceName);
        }
        catch (Exception e) {
            throw new LoopholeClosedException(serviceName, e);
        }
    }
}

