/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.annotation.SuppressLint;
import com.skype.android.util2.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class GLHelpers {
    private final String tag;
    @SuppressLint(value={"UseSparseArrays"})
    private static final Map<Integer, EGLError> EGL_ERRORS = new HashMap<Integer, EGLError>();

    public GLHelpers(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag");
        }
        this.tag = tag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EGLError {
        EGL_SUCCESS(12288),
        EGL_NOT_INITIALIZED(12289),
        EGL_BAD_ACCESS(12290),
        EGL_BAD_ALLOC(12291),
        EGL_BAD_ATTRIBUTE(12292),
        EGL_BAD_CONTEXT(12294),
        EGL_BAD_CONFIG(12293),
        EGL_BAD_CURRENT_SURFACE(12295),
        EGL_BAD_DISPLAY(12296),
        EGL_BAD_SURFACE(12301),
        EGL_BAD_MATCH(12297),
        EGL_BAD_PARAMETER(12300),
        EGL_BAD_NATIVE_PIXMAP(12298),
        EGL_BAD_NATIVE_WINDOW(12299),
        EGL_CONTEXT_LOST(12302);


        private EGLError(int code) {
            EGL_ERRORS.put(code, this);
        }
    }

    private static class EGLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EGLException(int code) {
            super(((EGLError)((Object)EGL_ERRORS.get(code))).name());
        }
    }

    public class ConfigSelector {
        private final int red;
        private final int green;
        private final int blue;
        private final int alpha;
        private final int depth;
        private final int stencil;
        private final int[] attributes;

        public ConfigSelector(int red, int green, int blue, int alpha, int depth, int stencil, int[] attributes) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.depth = depth;
            this.stencil = stencil;
            this.attributes = (int[])attributes.clone();
        }

        public EGLConfig selectConfig(EGL10 egl, EGLDisplay display) {
            if (Log.isLoggable(GLHelpers.this.tag, 3)) {
                Log.d(GLHelpers.this.tag, "selectConfig(): ENTER");
            }
            EGLConfigurations configs = null;
            try {
                configs = new EGLConfigurations(egl, display);
            }
            catch (EGLException e) {
                if (Log.isLoggable(GLHelpers.this.tag, 6)) {
                    Log.e(GLHelpers.this.tag, "Failed to get EGL configurations: " + e.getMessage());
                }
                return null;
            }
            for (EGLConfigurations.Item config : configs) {
                if (!this.isMatch(config)) continue;
                if (Log.isLoggable(GLHelpers.this.tag, 4)) {
                    int id = config.getAttribute(12328);
                    Log.i(GLHelpers.this.tag, "selected config: EGL_CONFIG_ID=" + id + ", rgb=" + this.red + ':' + this.green + ':' + this.blue);
                }
                return config.getEGLConfig();
            }
            if (Log.isLoggable(GLHelpers.this.tag, 6)) {
                Log.e(GLHelpers.this.tag, "no configurations found!");
            }
            return null;
        }

        private boolean isMatch(EGLConfigurations.Item config) {
            return config.getAttribute(12325) >= this.depth && config.getAttribute(12326) >= this.stencil && config.getAttribute(12324) == this.red && config.getAttribute(12323) == this.green && config.getAttribute(12322) == this.blue && config.getAttribute(12321) == this.alpha;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EGLConfigurations
        implements Iterable<Item> {
            private final EGL10 egl;
            private final EGLDisplay display;
            private final EGLConfig[] configs;

            public EGLConfigurations(EGL10 egl, EGLDisplay display) throws EGLException {
                this.egl = egl;
                this.display = display;
                this.configs = this.getConfigs();
            }

            private EGLConfig[] getConfigs() throws EGLException {
                int[] numConfigs = new int[1];
                if (!this.egl.eglChooseConfig(this.display, ConfigSelector.this.attributes, null, 0, numConfigs)) {
                    throw new EGLException(this.egl.eglGetError());
                }
                EGLConfig[] configs = new EGLConfig[numConfigs[0]];
                if (!this.egl.eglChooseConfig(this.display, ConfigSelector.this.attributes, configs, configs.length, numConfigs)) {
                    throw new EGLException(this.egl.eglGetError());
                }
                return configs;
            }

            @Override
            public Iterator<Item> iterator() {
                return new Iterator<Item>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < EGLConfigurations.this.configs.length;
                    }

                    @Override
                    public Item next() {
                        return new Item(EGLConfigurations.this.configs[this.index++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            private class Item {
                private final EGLConfig config;

                public Item(EGLConfig config) {
                    this.config = config;
                }

                public int getAttribute(int attribute) {
                    int[] result = new int[1];
                    return EGLConfigurations.this.egl.eglGetConfigAttrib(EGLConfigurations.this.display, this.config, attribute, result) ? result[0] : 0;
                }

                public EGLConfig getEGLConfig() {
                    return this.config;
                }
            }
        }
    }
}

