/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.CreateViewTelemetryEvent;
import com.azure.android.communication.calling.InternalPreviewRenderer;
import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.RendererListener;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.StreamSize;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.calling.VideoRenderer;
import com.azure.android.communication.calling.VideoStreamRendererView;
import com.skype.android.video.render.GLTextureView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public final class VideoStreamRenderer {
    private static final String TAG = "Renderer";
    private Map<UUID, VideoStreamRendererView> allViews = new HashMap<UUID, VideoStreamRendererView>();
    private ArrayList<RendererListener> listeners = new ArrayList();
    private StreamSize streamSize;
    private boolean isRendering;
    private LocalVideoStream localVideoStream;
    private Context context;
    private VideoOrientationManager videoOrientationManager;
    private InternalPreviewRenderer previewRenderer;
    private RemoteVideoStream remoteVideoStream;
    private VideoRenderer remoteVideoRenderer;
    private ArrayList<RemoteVideoEventListener> remoteVideoEventListeners;
    private AtomicBoolean remoteVideoStarted = new AtomicBoolean(false);
    private PropertyChangedListener remoteVideoStreamStateChangeListener;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private UUID viewId;
    private UUID correlationId;
    private static Map<Long, VideoStreamRenderer> RENDERERS = new HashMap<Long, VideoStreamRenderer>();

    static VideoStreamRenderer getRenderer(LocalVideoStream localVideoStream) {
        return RENDERERS.get(localVideoStream.handle);
    }

    public VideoStreamRenderer(LocalVideoStream localVideoStream, Context context) {
        this(context, localVideoStream.handle);
        this.localVideoStream = localVideoStream;
    }

    public VideoStreamRenderer(RemoteVideoStream remoteVideoStream, Context context) {
        this(context, remoteVideoStream.handle);
        this.remoteVideoStream = remoteVideoStream;
    }

    private VideoStreamRenderer(Context context, long handle) {
        if (RENDERERS.containsKey(handle)) {
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED);
        }
        this.context = context;
        this.videoOrientationManager = VideoOrientationManager.getInstance(context);
        this.remoteVideoEventListeners = new ArrayList();
        RENDERERS.put(handle, this);
    }

    public VideoStreamRendererView createView() {
        return this.createView(new CreateViewOptions(ScalingMode.CROP));
    }

    public VideoStreamRendererView createView(CreateViewOptions options) {
        int causeId = (int)(Math.random() * 2.147483647E9);
        Log.debug1(TAG, "createView() causeId: 0x%08x", causeId);
        this.viewId = UUID.randomUUID();
        this.correlationId = UUID.randomUUID();
        CreateViewTelemetryEvent createViewEvent = new CreateViewTelemetryEvent(this.viewId, this.correlationId);
        if (this.allViews.size() > 0) {
            if (this.localVideoStream != null) {
                createViewEvent.sendAttemptForLocalStream(this.localVideoStream);
                createViewEvent.sendFailedForLocalStream(this.localVideoStream, "Multiple views are not supported");
            } else {
                assert (this.remoteVideoStream != null) : "remoteVideoStream is null";
                if (this.remoteVideoStream != null) {
                    createViewEvent.sendAttemptForRemoteStream(this.remoteVideoStream);
                    createViewEvent.sendFailedForRemoteStream(this.remoteVideoStream, "Multiple views are not supported");
                }
            }
            throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED);
        }
        if (this.localVideoStream != null) {
            VideoStreamRendererView view = new VideoStreamRendererView(this, this.videoOrientationManager, options, this.context);
            this.allViews.put(this.viewId, view);
            createViewEvent.sendAttemptForLocalStream(this.localVideoStream);
            Executors.newCachedThreadPool().submit(() -> {
                if (this.previewRenderer == null) {
                    this.previewRenderer = new InternalPreviewRenderer(this);
                }
                this.previewRenderer.createBinding(this.localVideoStream);
                Handler uiHandler = new Handler(Looper.getMainLooper());
                uiHandler.post(() -> {
                    if (this.localVideoStream != null) {
                        view.attachVideo(this.localVideoStream.getSource().getCameraFacing(), causeId);
                    }
                });
            });
            return view;
        }
        if (this.remoteVideoRenderer == null) {
            this.remoteVideoRenderer = new VideoRenderer(new VideoRendererCallback(), this.remoteVideoStream.getId());
        }
        VideoStreamRendererView view = new VideoStreamRendererView(this, options, this.context);
        this.allViews.put(this.viewId, view);
        createViewEvent.sendAttemptForRemoteStream(this.remoteVideoStream);
        this.remoteVideoStreamStateChangeListener = this::videoStateChanged;
        this.remoteVideoStream.addOnVideoStatusChangedListenerInternal(this.remoteVideoStreamStateChangeListener);
        this.remoteVideoStreamStateChangeListener.onPropertyChanged(null);
        return view;
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            android.util.Log.w((String)TAG, (String)"App attempted to dispose a Renderer object which was already disposed earlier.");
            Log.debug1(TAG, "Already disposed", new Object[0]);
            return;
        }
        int causeId = (int)(Math.random() * 2.147483647E9);
        Log.debug1(TAG, "dispose() causeId: 0x%08x", causeId);
        for (VideoStreamRendererView view : this.allViews.values()) {
            view.dispose(causeId);
        }
        this.allViews = null;
        if (this.previewRenderer != null) {
            this.previewRenderer.releaseBinding(this.localVideoStream);
            RENDERERS.remove(this.localVideoStream.handle);
            this.localVideoStream = null;
        } else {
            this.remoteVideoStream.removeOnVideoStatusChangedListenerInternal(this.remoteVideoStreamStateChangeListener);
            this.remoteVideoStreamStateChangeListener = null;
            this.remoteVideoRenderer.stopVideo(this.remoteVideoStream);
            RENDERERS.remove(this.remoteVideoStream.handle);
            this.remoteVideoStream = null;
        }
        this.remoteVideoEventListeners.clear();
    }

    public StreamSize getSize() {
        return this.streamSize;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    boolean isRendering() {
        return this.isRendering;
    }

    private void videoStateChanged(PropertyChangedEvent args) {
        if (this.disposed.get()) {
            return;
        }
        if (this.remoteVideoStarted.get() == this.remoteVideoStream.isAvailable()) {
            return;
        }
        if (this.remoteVideoStarted.compareAndSet(false, this.remoteVideoStream.isAvailable())) {
            this.remoteVideoRenderer.startVideo(this.remoteVideoStream);
        } else if (this.remoteVideoStarted.compareAndSet(true, this.remoteVideoStream.isAvailable())) {
            this.remoteVideoRenderer.stopVideo(this.remoteVideoStream);
        }
    }

    void releaseLocalBindingForSwitching(int causeId) {
        Log.debug1(TAG, "releaseLocalBindingForSwitching causeId: 0x%08x", causeId);
        if (this.previewRenderer != null) {
            this.previewRenderer.releaseBinding(this.localVideoStream);
            this.isRendering = false;
            this.previewRenderer = null;
            Log.debug1(TAG, "releaseLocalBindingForSwitching binding released causeId: 0x%08x", causeId);
        }
    }

    void recreateLocalBindingForSwitching(int causeId) {
        Log.debug1(TAG, "recreateLocalBindingForSwitching causeId: 0x%08x", causeId);
        this.previewRenderer = new InternalPreviewRenderer(this);
        this.previewRenderer.createBinding(this.localVideoStream);
        VideoStreamRendererView view = this.allViews.get(this.viewId);
        Handler uiHandler = new Handler(Looper.getMainLooper());
        uiHandler.post(() -> {
            view.removeAllViews();
            view.attachVideo(this.localVideoStream.getSource().getCameraFacing(), causeId);
            Log.debug1(TAG, "recreateLocalBindingForSwitching causeId: 0x%08x", causeId);
        });
    }

    void onFrameSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        this.streamSize = new StreamSize(width, height);
        boolean startedRendering = !this.isRendering;
        this.isRendering = true;
        Executors.newCachedThreadPool().submit(() -> {
            for (VideoStreamRendererView view : this.allViews.values()) {
                view.onFrameSizeChanged(surfaceTexture, width, height);
            }
            if (startedRendering) {
                for (RendererListener listener : this.listeners) {
                    listener.onFirstFrameRendered();
                }
            }
        });
        if (startedRendering) {
            CreateViewTelemetryEvent successCreateViewEvent = new CreateViewTelemetryEvent(this.viewId, this.correlationId);
            VideoStreamRendererView view = this.allViews.get(this.viewId);
            successCreateViewEvent.sendSuccessForLocalStream(this.localVideoStream, view.getWidth(), view.getHeight());
        }
    }

    void onPreviewSurfaceUnset(SurfaceTexture surfaceTexture) {
        int causeId = (int)(Math.random() * 2.147483647E9);
        Log.debug1(TAG, "onPreviewSurfaceUnset causeId: 0x%08x", causeId);
    }

    void onBindingFailed() {
        Executors.newCachedThreadPool().submit(() -> {
            Log.debug1(TAG, "onBindingFailed()", new Object[0]);
            for (RendererListener listener : this.listeners) {
                listener.onRendererFailedToStart();
            }
        });
        CreateViewTelemetryEvent createViewEvent = new CreateViewTelemetryEvent(this.viewId, this.correlationId);
        if (this.localVideoStream != null) {
            createViewEvent.sendFailedForLocalStream(this.localVideoStream, "Start preview binding failed");
        } else {
            assert (this.remoteVideoStream != null) : "remoteVideoStream is null";
            if (this.remoteVideoStream != null) {
                createViewEvent.sendFailedForRemoteStream(this.remoteVideoStream, "Failed to render video for remote stream");
            }
        }
    }

    void onSurfaceTextureAvailable(SurfaceTexture surface) {
        if (this.localVideoStream != null) {
            this.previewRenderer.attachSurface(surface);
        }
    }

    void onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.localVideoStream != null) {
            this.previewRenderer.detachSurface(surface);
        }
    }

    GLTextureView createView(GLTextureView.SurfaceTextureAvailableListener listener) {
        return this.remoteVideoRenderer.createView(this.context, listener);
    }

    void addListener(RemoteVideoEventListener listener) {
        this.remoteVideoEventListeners.add(listener);
    }

    void removeListener(RemoteVideoEventListener listener) {
        this.remoteVideoEventListeners.remove(listener);
    }

    class VideoRendererCallback
    implements VideoRenderer.Callback {
        private static final String TAG = "VideoRendererCallback";

        VideoRendererCallback() {
        }

        @Override
        public void onBindingAttached() {
            Log.debug1(TAG, "onBindingAttached()", new Object[0]);
        }

        @Override
        public void onBindingDetached() {
            Log.debug1(TAG, "onBindingDetached()", new Object[0]);
        }

        @Override
        public void onBindingFailed() {
            Log.debug1(TAG, "onBindingFailed()", new Object[0]);
            VideoStreamRenderer.this.onBindingFailed();
        }

        @Override
        public void onSizeChanged(View view, int w, int h) {
            int causeId = (int)(Math.random() * 2.147483647E9);
            Log.debug1(TAG, "onSizeChanged(), causeId: 0x%08x", causeId);
            VideoStreamRenderer.this.streamSize = new StreamSize(w, h);
            for (RemoteVideoEventListener listener : VideoStreamRenderer.this.remoteVideoEventListeners) {
                listener.onSizeChanged(w, h, causeId);
            }
        }

        @Override
        public void onFirstFrameRendered(View view) {
            VideoStreamRenderer.this.isRendering = true;
            Executors.newCachedThreadPool().submit(() -> {
                Log.debug1(TAG, "onFirstFrameRendered()", new Object[0]);
                for (RendererListener listener : VideoStreamRenderer.this.listeners) {
                    listener.onFirstFrameRendered();
                }
            });
            CreateViewTelemetryEvent successCreateViewEvent = new CreateViewTelemetryEvent(VideoStreamRenderer.this.viewId, VideoStreamRenderer.this.correlationId);
            successCreateViewEvent.sendSuccessForRemoteStream(VideoStreamRenderer.this.remoteVideoStream, view.getWidth(), view.getHeight());
        }

        @Override
        public void onRendererDisposed(VideoRenderer VideoRenderer2, View view) {
            Log.debug1(TAG, "onRendererDisposed()", new Object[0]);
        }
    }

    static interface RemoteVideoEventListener {
        public void onSizeChanged(int var1, int var2, int var3);
    }
}

