/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocalVideoStreamsUpdatedEvent {
    long handle;

    LocalVideoStreamsUpdatedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_local_video_streams_updated_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_streams_updated_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<LocalVideoStream> getAddedStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_streams_updated_event_args_get_added_streams(this.handle, result, result_length));
        ArrayList<LocalVideoStream> resultList = new ArrayList<LocalVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(LocalVideoStream.getInstance(resultArray[i], true));
        }
        List<LocalVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<LocalVideoStream> getRemovedStreams() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_streams_updated_event_args_get_removed_streams(this.handle, result, result_length));
        ArrayList<LocalVideoStream> resultList = new ArrayList<LocalVideoStream>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(LocalVideoStream.getInstance(resultArray[i], true));
        }
        List<LocalVideoStream> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    static LocalVideoStreamsUpdatedEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStreamsUpdatedEvent, LocalVideoStreamsUpdatedEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_local_video_streams_updated_event_args_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStreamsUpdatedEvent, LocalVideoStreamsUpdatedEvent.class, false);
    }
}

