/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.TokenRequestedListener;
import java.util.ArrayList;
import java.util.List;

final class InternalTokenProvider {
    long handle;
    private List<TokenRequestedListener> OnTokenRequestedListeners = new ArrayList<TokenRequestedListener>();

    InternalTokenProvider(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_internal_token_provider_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    InternalTokenProvider(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    public InternalTokenProvider() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_internal_token_provider_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_release(this.handle));
        this.handle = 0L;
    }

    private static void OnTokenRequestedStaticHandler(long cookie, long sender) {
        InternalTokenProvider instance = InternalTokenProvider.getInstance(cookie);
        if (instance != null) {
            InternalTokenProvider sender_converted = sender != 0L ? InternalTokenProvider.getInstance(sender, false) : null;
            for (TokenRequestedListener listener : instance.OnTokenRequestedListeners) {
                listener.onTokenRequested(sender_converted);
            }
        }
    }

    public void addOnTokenRequestedListener(TokenRequestedListener listener) {
        this.OnTokenRequestedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnTokenRequested", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_set_on_token_requested(this.handle, this.getHandle(), this));
    }

    public void removeOnTokenRequestedListener(TokenRequestedListener listener) {
        this.OnTokenRequestedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnTokenRequested", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_set_on_token_requested(this.handle, 0L, null));
        }
    }

    public void setToken(String token, String accountIdentity, String displayName, String resourceId, String countryCode) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_set_token(this.handle, token, accountIdentity, displayName, resourceId, countryCode));
    }

    public void parseToken(String token) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_parse_token(this.handle, token));
    }

    public void setError(String error) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_token_provider_set_error(this.handle, error));
    }

    static InternalTokenProvider getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalTokenProvider, InternalTokenProvider.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_internal_token_provider_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalTokenProvider, InternalTokenProvider.class, false);
    }

    private static InternalTokenProvider getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalTokenProvider, InternalTokenProvider.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnTokenRequested")) {
            this.addOnTokenRequestedListener((TokenRequestedListener)eventListener);
        }
    }
}

