/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.InternalIdentifiersListUpdatedListener;
import com.azure.android.communication.calling.InternalRegisteredIdentifiersChangedEvent;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.Status;
import java.util.ArrayList;
import java.util.List;

final class InternalCallClientEvents {
    long handle;
    private List<InternalIdentifiersListUpdatedListener> OnCallAgentRegisteredIdentifierChangedListeners = new ArrayList<InternalIdentifiersListUpdatedListener>();

    InternalCallClientEvents(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_internal_call_client_events_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    InternalCallClientEvents(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    public InternalCallClientEvents() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_internal_call_client_events_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_call_client_events_release(this.handle));
        this.handle = 0L;
    }

    private static void OnCallAgentRegisteredIdentifierChangedStaticHandler(long cookie, long args) {
        InternalCallClientEvents instance = InternalCallClientEvents.getInstance(cookie);
        if (instance != null) {
            InternalRegisteredIdentifiersChangedEvent args_converted = args != 0L ? InternalRegisteredIdentifiersChangedEvent.getInstance(args, false) : null;
            for (InternalIdentifiersListUpdatedListener listener : instance.OnCallAgentRegisteredIdentifierChangedListeners) {
                listener.onInternalIdentifiersListUpdated(args_converted);
            }
        }
    }

    public void addOnCallAgentRegisteredIdentifierChangedListener(InternalIdentifiersListUpdatedListener listener) {
        this.OnCallAgentRegisteredIdentifierChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallAgentRegisteredIdentifierChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_call_client_events_set_on_call_agent_registered_identifier_changed(this.handle, this.getHandle(), this));
    }

    public void removeOnCallAgentRegisteredIdentifierChangedListener(InternalIdentifiersListUpdatedListener listener) {
        this.OnCallAgentRegisteredIdentifierChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallAgentRegisteredIdentifierChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_internal_call_client_events_set_on_call_agent_registered_identifier_changed(this.handle, 0L, null));
        }
    }

    static InternalCallClientEvents getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalCallClientEvents, InternalCallClientEvents.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_internal_call_client_events_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalCallClientEvents, InternalCallClientEvents.class, false);
    }

    private static InternalCallClientEvents getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.InternalCallClientEvents, InternalCallClientEvents.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallAgentRegisteredIdentifierChanged")) {
            this.addOnCallAgentRegisteredIdentifierChangedListener((InternalIdentifiersListUpdatedListener)eventListener);
        }
    }
}

