/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.GroupCallLocator;
import com.azure.android.communication.calling.HandleType;
import com.azure.android.communication.calling.JoinMeetingLocator;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.RecordingCallFeature;
import com.azure.android.communication.calling.TeamsMeetingCoordinatesLocator;
import com.azure.android.communication.calling.TeamsMeetingLinkLocator;
import com.azure.android.communication.calling.TranscriptionCallFeature;

class Factories {
    Factories() {
    }

    static JoinMeetingLocator JoinMeetingLocatorFactory(long handle, boolean transfer) {
        JoinMeetingLocator result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case GROUP_CALL_LOCATOR: {
                result_object = GroupCallLocator.getInstance(handle, transfer);
                break;
            }
            case TEAMS_MEETING_COORDINATES_LOCATOR: {
                result_object = TeamsMeetingCoordinatesLocator.getInstance(handle, transfer);
                break;
            }
            case TEAMS_MEETING_LINK_LOCATOR: {
                result_object = TeamsMeetingLinkLocator.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }

    static CallFeature CallFeatureFactory(long handle, boolean transfer) {
        CallFeature result_object;
        if (handle == 0L) {
            return null;
        }
        Out<HandleType> result = new Out<HandleType>();
        NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_get_handle_type(handle, result));
        switch ((HandleType)((Object)result.value)) {
            case RECORDING_CALL_FEATURE: {
                result_object = RecordingCallFeature.getInstance(handle, transfer);
                break;
            }
            case TRANSCRIPTION_CALL_FEATURE: {
                result_object = TranscriptionCallFeature.getInstance(handle, transfer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result_object;
    }
}

