/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.hardware.Camera;
import com.azure.android.communication.calling.CameraFacing;
import com.azure.android.communication.calling.Log;

class DeviceProfile {
    private static final String TAG = "DeviceProfile";
    static int frontCameraMounting;
    static int rearCameraMounting;

    DeviceProfile() {
    }

    static synchronized boolean changePreviewDimensions(CameraFacing cameraFacing, int deviceOrientation) {
        if (deviceOrientation == -1) {
            Log.debug6(TAG, "device orientation not known (-1), assuming camera and screen aligned", new Object[0]);
            return false;
        }
        if (cameraFacing == CameraFacing.FRONT) {
            return (frontCameraMounting + deviceOrientation) % 180 != 0;
        }
        if (cameraFacing == CameraFacing.BACK) {
            return (rearCameraMounting - deviceOrientation) % 180 != 0;
        }
        return false;
    }

    static {
        try {
            int num = Camera.getNumberOfCameras();
            for (int i = 0; i < num; ++i) {
                Camera.CameraInfo info = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 1) {
                    frontCameraMounting = info.orientation;
                }
                if (info.facing != 0) continue;
                rearCameraMounting = info.orientation;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

