/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.LocalVideoStream;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.RemoteVideoStream;
import com.azure.android.communication.calling.Status;
import java.util.UUID;

final class CreateViewTelemetryEvent {
    long handle;

    CreateViewTelemetryEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_create_view_telemetry_event_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CreateViewTelemetryEvent(UUID viewId, UUID correlationId) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_create_view_telemetry_event_create_guid_view_id_guid_correlation_id(viewId, correlationId, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_release(this.handle));
        this.handle = 0L;
    }

    public UUID getViewId() {
        Out<UUID> result = new Out<UUID>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_get_view_id(this.handle, result));
        return (UUID)result.value;
    }

    public UUID getCorrelationId() {
        Out<UUID> result = new Out<UUID>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_get_correlation_id(this.handle, result));
        return (UUID)result.value;
    }

    public void sendAttemptForLocalStream(LocalVideoStream localStream) {
        long localStream_converted = localStream != null ? localStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_attempt_for_local_stream(this.handle, localStream_converted));
    }

    public void sendAttemptForRemoteStream(RemoteVideoStream remoteStream) {
        long remoteStream_converted = remoteStream != null ? remoteStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_attempt_for_remote_stream(this.handle, remoteStream_converted));
    }

    public void sendSuccessForLocalStream(LocalVideoStream localStream, int width, int height) {
        long localStream_converted = localStream != null ? localStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_success_for_local_stream(this.handle, localStream_converted, width, height));
    }

    public void sendSuccessForRemoteStream(RemoteVideoStream remoteStream, int width, int height) {
        long remoteStream_converted = remoteStream != null ? remoteStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_success_for_remote_stream(this.handle, remoteStream_converted, width, height));
    }

    public void sendFailedForLocalStream(LocalVideoStream localStream, String reason) {
        long localStream_converted = localStream != null ? localStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_failed_for_local_stream(this.handle, localStream_converted, reason));
    }

    public void sendFailedForRemoteStream(RemoteVideoStream remoteStream, String reason) {
        long remoteStream_converted = remoteStream != null ? remoteStream.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_telemetry_event_send_failed_for_remote_stream(this.handle, remoteStream_converted, reason));
    }

    static CreateViewTelemetryEvent getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CreateViewTelemetryEvent, CreateViewTelemetryEvent.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_create_view_telemetry_event_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CreateViewTelemetryEvent, CreateViewTelemetryEvent.class, false);
    }
}

