/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.graphics.egl;

import com.microsoft.dl.DiagUtils;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.EGLUtils;
import com.microsoft.dl.video.graphics.egl.TargetSurfaceContext;
import com.microsoft.dl.video.utils.Resolution;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

abstract class AbstractTargetSurfaceContext
implements TargetSurfaceContext {
    protected static final EGL10 EGL = (EGL10)EGLContext.getEGL();
    protected final String diagName = DiagUtils.getObjName((Object)this);
    protected EGLDisplay eglDisplay = EGL10.EGL_NO_DISPLAY;
    protected EGLContext eglContext = EGL10.EGL_NO_CONTEXT;
    protected EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;
    protected EGLConfig eglConfig;
    protected Resolution surfaceSize;

    public AbstractTargetSurfaceContext(int[] configAttributes) throws EGLException {
        int[] contextAttributes = new EGLUtils.ContextAttributesBuilder().contextClientVersion(2).build();
        this.eglDisplay = AbstractTargetSurfaceContext.createDispalay();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " display created: [0x" + Integer.toHexString(System.identityHashCode(this.eglDisplay)) + "] " + this.getDisplayInfo()));
        }
        this.eglConfig = AbstractTargetSurfaceContext.chooseConfig(this.eglDisplay, configAttributes);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " config created: [0x" + Integer.toHexString(System.identityHashCode(this.eglConfig)) + "] " + this.getConfigInfo()));
        }
        this.eglContext = AbstractTargetSurfaceContext.createContext(this.eglDisplay, this.eglConfig, contextAttributes);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " context created: [0x" + Integer.toHexString(System.identityHashCode(this.eglContext)) + "] " + this.getContextInfo()));
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)(this.diagName + " created"));
        }
    }

    @Override
    public Resolution getSurfaceSize() throws EGLException {
        return this.surfaceSize;
    }

    @Override
    public boolean isCurrent() {
        return EGL.eglGetCurrentDisplay().equals(this.eglDisplay) && EGL.eglGetCurrentContext().equals(this.eglContext) && EGL.eglGetCurrentSurface(12377).equals(this.eglSurface);
    }

    @Override
    public void makeCurrent(boolean isCurrent) throws EGLException {
        boolean isSucceeded;
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            return;
        }
        boolean bl = isSucceeded = isCurrent ? EGL.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext) : EGL.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        if (!isSucceeded) {
            throw new EGLException("EGL.eglMakeCurrent() has failed in " + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_MAKE_CURRENT_FAILED);
        }
        EGLException.checkAfter("EGL.eglMakeCurrent()", ErrorCode.ANDROID_EGL_MAKE_CURRENT_FAILED);
    }

    @Override
    public void swapBuffers() throws GraphicsException {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new EGLException("No display", ErrorCode.ANDROID_EGL_NO_DISPLAY);
        }
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new EGLException("No surface", ErrorCode.ANDROID_EGL_NO_SURFACE);
        }
        if (!EGL.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
            throw new EGLException("EGL.eglSwapBuffers() has failed in " + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_SWAP_BUFFERS_FAILED);
        }
        EGLException.checkAfter("EGL.swapBuffers()", ErrorCode.ANDROID_EGL_SWAP_BUFFERS_FAILED);
    }

    @Override
    public void close() throws EGLException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " closing"));
        }
        Exception exception = null;
        try {
            this.releaseSurface();
        }
        catch (EGLException | RuntimeException e) {
            exception = exception == null ? e : exception;
        }
        try {
            this.releaseContext();
        }
        catch (EGLException | RuntimeException e) {
            exception = exception == null ? e : exception;
        }
        try {
            this.releaseDisplay();
        }
        catch (EGLException | RuntimeException e) {
            Exception exception2 = exception = exception == null ? e : exception;
        }
        if (exception instanceof EGLException) {
            throw (EGLException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)(this.diagName + " closed"));
        }
    }

    protected boolean hasSurface() {
        return this.eglSurface != null && this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    protected void releaseSurface() throws EGLException {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY || this.eglSurface == EGL10.EGL_NO_SURFACE) {
            return;
        }
        if (!EGL.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
            throw new EGLException("EGL.eglDestroySurface() has failed in" + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_DESTROY_SURFACE_FAILED);
        }
        EGLException.checkAfter("EGL.eglDestroySurface()", ErrorCode.ANDROID_EGL_DESTROY_SURFACE_FAILED);
        this.eglSurface = EGL10.EGL_NO_SURFACE;
        this.surfaceSize = null;
    }

    private static EGLDisplay createDispalay() throws EGLException {
        EGLDisplay eglDisplay = EGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eglDisplay == null || eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new EGLException("EGL.eglGetDisplay() has failed", EGL.eglGetError(), ErrorCode.ANDROID_EGL_GET_DISPLAY_FAILED);
        }
        EGLException.checkAfter("EGL.eglGetDisplay()", ErrorCode.ANDROID_EGL_GET_DISPLAY_FAILED);
        int[] eglVersion = new int[2];
        if (!EGL.eglInitialize(eglDisplay, eglVersion)) {
            throw new EGLException("EGL.eglInitialize() has failed", EGL.eglGetError(), ErrorCode.ANDROID_EGL_INITIALIZE_FAILED);
        }
        EGLException.checkAfter("EGL.eglInitialize()", ErrorCode.ANDROID_EGL_INITIALIZE_FAILED);
        return eglDisplay;
    }

    private static EGLConfig chooseConfig(EGLDisplay eglDisplay, int[] attributes) throws EGLException {
        EGLConfig[] eglConfigs = new EGLConfig[1];
        int[] numEglConfigs = new int[1];
        if (!EGL.eglChooseConfig(eglDisplay, attributes, eglConfigs, eglConfigs.length, numEglConfigs)) {
            throw new EGLException("EGL.eglChooseConfig() has failed", EGL.eglGetError(), ErrorCode.ANDROID_EGL_CHOOSE_CONFIG_FAILED);
        }
        EGLException.checkAfter("EGL.eglChooseConfig()", ErrorCode.ANDROID_EGL_CHOOSE_CONFIG_FAILED);
        if (numEglConfigs[0] <= 0) {
            throw new EGLException("EGL.eglChooseConfig() returned 0 configs", EGL.eglGetError(), ErrorCode.ANDROID_EGL_NO_CONFIGS);
        }
        return eglConfigs[0];
    }

    private static EGLContext createContext(EGLDisplay eglDisplay, EGLConfig eglConfig, int[] attributes) throws EGLException {
        EGLContext eglContext = EGL.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attributes);
        if (eglContext == null || eglContext == EGL10.EGL_NO_CONTEXT) {
            throw new EGLException("EGL.eglCreateContext() has failed", EGL.eglGetError(), ErrorCode.ANDROID_EGL_CREATE_CONTEXT_FAILED);
        }
        EGLException.checkAfter("EGL .eglCreateContext()", ErrorCode.ANDROID_EGL_CREATE_CONTEXT_FAILED);
        return eglContext;
    }

    private void releaseDisplay() throws EGLException {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            return;
        }
        if (!EGL.eglTerminate(this.eglDisplay)) {
            throw new EGLException("EGL.eglTerminate() has failed in " + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_TERMINATE_FAILED);
        }
        EGLException.checkAfter("EGL.eglTerminate()", ErrorCode.ANDROID_EGL_TERMINATE_FAILED);
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
    }

    private void releaseContext() throws EGLException {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY || this.eglContext == EGL10.EGL_NO_CONTEXT) {
            return;
        }
        if (!EGL.eglDestroyContext(this.eglDisplay, this.eglContext)) {
            throw new EGLException("EGL.eglDestroyContext() has failed in " + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_DESTROY_CONTEXT_FAILED);
        }
        EGLException.checkAfter("EGL.eglDestroyContext()", ErrorCode.ANDROID_EGL_DESTROY_CONTEXT_FAILED);
        this.eglContext = EGL10.EGL_NO_CONTEXT;
    }

    private String getDisplayInfo() {
        StringBuilder str = new StringBuilder();
        for (EGLUtils.DisplayAttribute attr : EGLUtils.DisplayAttribute.values()) {
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(attr);
            str.append("='");
            str.append(EGL.eglQueryString(this.eglDisplay, attr.getCode()));
            str.append('\'');
        }
        return str.toString();
    }

    private String getConfigInfo() {
        StringBuilder str = new StringBuilder();
        int[] value = new int[]{0};
        for (EGLUtils.ConfigAttribute attr : EGLUtils.ConfigAttribute.values()) {
            if (!EGL.eglGetConfigAttrib(this.eglDisplay, this.eglConfig, attr.getCode(), value)) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(attr);
            str.append("=");
            str.append(attr.parseValue(value[0]));
        }
        return str.toString();
    }

    private String getContextInfo() {
        StringBuilder str = new StringBuilder();
        int[] value = new int[]{0};
        for (EGLUtils.ContextAttribute attr : EGLUtils.ContextAttribute.values()) {
            if (!EGL.eglQueryContext(this.eglDisplay, this.eglContext, attr.getCode(), value)) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(attr);
            str.append("=");
            str.append(attr.parseValue(value[0]));
        }
        return str.toString();
    }

    protected String getSurfaceInfo() {
        StringBuilder str = new StringBuilder();
        int[] value = new int[]{0};
        for (EGLUtils.SurfaceAttribute attr : EGLUtils.SurfaceAttribute.values()) {
            if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, attr.getCode(), value)) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(attr);
            str.append("=");
            str.append(attr.parseValue(value[0]));
        }
        return str.toString();
    }

    public String toString() {
        return this.diagName + " [eglDisplay=0x" + Integer.toHexString(System.identityHashCode(this.eglDisplay)) + ", eglConfig=0x" + Integer.toHexString(System.identityHashCode(this.eglConfig)) + ", eglContext=0x" + Integer.toHexString(System.identityHashCode(this.eglContext)) + ", eglSurface=0x" + Integer.toHexString(System.identityHashCode(this.eglSurface)) + ", surfaceSize=" + this.surfaceSize + "]";
    }
}

