/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.real.impl2;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.os.Looper;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.DeviceManager;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.real.impl.CameraCapabilitiesUtils;
import com.microsoft.dl.video.capture.impl.real.impl2.Camera2CapabilitiesUtils;
import com.microsoft.dl.video.capture.impl.real.impl2.RealCamera2Impl;
import java.lang.ref.WeakReference;
import java.util.Map;

public class RealCamera2ManagerImpl
implements com.microsoft.dl.video.capture.api.CameraManager {
    private final Object capabilitiesLock = new Object();
    private Map<String, CameraCapabilities> capabilities;
    private Map<String, StaticCameraCapabilities> staticCapabilities;
    private final CameraManager.AvailabilityCallback availabilityCallback = new CameraManager.AvailabilityCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraAvailable(String cameraId) {
            super.onCameraAvailable(cameraId);
            Log.log((int)5, (String)"Video", (String)("RealCamera2ManagerImpl onCameraAvailable cameraId: " + cameraId));
            try {
                Object availableCameraStaticCap;
                if (cameraId == null || RealCamera2ManagerImpl.this.staticCapabilities == null || DeviceManager.getInstance().isDeviceListed(cameraId)) {
                    return;
                }
                if (!RealCamera2ManagerImpl.this.staticCapabilities.containsKey(cameraId)) {
                    availableCameraStaticCap = Camera2CapabilitiesUtils.getStaticCameraCapabilities(cameraId);
                    RealCamera2ManagerImpl.this.staticCapabilities.put(cameraId, availableCameraStaticCap);
                    Log.log((int)5, (String)"Video", (String)("RealCamera2ManagerImpl collection camera static capabilities: " + ((StaticCameraCapabilities)availableCameraStaticCap).toString()));
                }
                availableCameraStaticCap = RealCamera2ManagerImpl.this.capabilitiesLock;
                synchronized (availableCameraStaticCap) {
                    if (RealCamera2ManagerImpl.this.capabilities != null && !RealCamera2ManagerImpl.this.capabilities.containsKey(cameraId)) {
                        new CollectCapabilitiesThread(RealCamera2ManagerImpl.this, cameraId).start();
                    }
                }
                DeviceManager.getInstance().notifyDeviceChanged(cameraId, true);
            }
            catch (CaptureException e) {
                Log.log((int)6, (String)"Video", (String)"ERROR: onCameraAvailable cause exception.", (Throwable)e);
            }
        }
    };

    private RealCamera2ManagerImpl() {
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        if (cameraManager == null) {
            Log.log((int)6, (String)"Video", (String)"ERROR: cameraManager is null");
            return;
        }
        cameraManager.registerAvailabilityCallback(this.availabilityCallback, new Handler(Looper.getMainLooper()));
    }

    @Override
    public final String[] getCameraIds() throws CaptureException {
        Context ctx;
        CameraManager cameraManager;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("CAMERA2:getCameraIds starts with instance: " + this));
        }
        if ((cameraManager = (CameraManager)(ctx = Platform.getInfo().getAppContext()).getSystemService("camera")) == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"ERROR: cameraManager is null");
            }
            throw new CaptureException("android.hardware.camera2.CameraManager null", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
        try {
            return cameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught ", (Throwable)e);
            }
            throw new CaptureException(e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
    }

    @Override
    public final Camera openCamera(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("CAMERA2:openCamera: " + id));
        }
        return new RealCamera2Impl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CameraCapabilities getCameraCapabilities(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"CAMERA2:getCameraCapabilities");
        }
        Object object = this.capabilitiesLock;
        synchronized (object) {
            if (this.capabilities == null) {
                this.capabilities = Camera2CapabilitiesUtils.obtain();
            }
            if (this.capabilities != null && !this.capabilities.containsKey(id)) {
                this.collectCameraCapabilitiesAndSave(id);
            }
            if (this.capabilities == null || !this.capabilities.containsKey(id)) {
                throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
            }
            return this.capabilities.get(id).clone();
        }
    }

    @Override
    public final StaticCameraCapabilities getStaticCameraCapabilities(String id) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"CAMERA2:getStaticCameraCapabilities");
        }
        if (this.staticCapabilities == null) {
            this.staticCapabilities = Camera2CapabilitiesUtils.obtainStatic();
        }
        if (!this.staticCapabilities.containsKey(id)) {
            throw new CaptureException("No such camera " + id, ErrorCode.ANDROID_CAMERA_INVALID_ID);
        }
        return this.staticCapabilities.get(id).clone();
    }

    @Override
    public void close() {
        Context ctx = Platform.getInfo().getAppContext();
        CameraManager cameraManager = (CameraManager)ctx.getSystemService("camera");
        if (cameraManager != null) {
            cameraManager.unregisterAvailabilityCallback(this.availabilityCallback);
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)"CAMERA2:close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCameraCapabilitiesAndSave(String cameraId) throws CaptureException {
        CameraCapabilities availableCameraCap = Camera2CapabilitiesUtils.getCameraCapabilities(cameraId);
        Object object = this.capabilitiesLock;
        synchronized (object) {
            this.capabilities.put(cameraId, availableCameraCap);
            Log.log((int)5, (String)"Video", (String)("RealCamera2ManagerImpl collection camera capabilities: " + availableCameraCap.toString()));
            try {
                CameraCapabilitiesUtils.save(this.capabilities, 2);
                Log.log((int)5, (String)"Video", (String)("RealCamera2ManagerImpl save camera capabilities for camera: " + cameraId));
            }
            catch (CameraCapabilitiesUtils.SerializationFailedException e) {
                Log.log((int)6, (String)"Video", (String)"Could not save camera capabilities to file", (Throwable)e);
            }
        }
    }

    private static class CollectCapabilitiesThread
    extends Thread {
        private final WeakReference<RealCamera2ManagerImpl> reference;
        private final String cameraId;

        public CollectCapabilitiesThread(RealCamera2ManagerImpl impl, String cameraId) {
            this.reference = new WeakReference<RealCamera2ManagerImpl>(impl);
            this.cameraId = cameraId;
        }

        @Override
        public void run() {
            RealCamera2ManagerImpl impl;
            RealCamera2ManagerImpl realCamera2ManagerImpl = impl = this.reference == null ? null : (RealCamera2ManagerImpl)this.reference.get();
            if (impl != null) {
                try {
                    impl.collectCameraCapabilitiesAndSave(this.cameraId);
                }
                catch (CaptureException exception) {
                    Log.log((int)6, (String)"Video", (String)"Error: ", (Throwable)exception);
                }
            }
        }
    }

    public static class Factory
    implements CameraManagerFactory {
        @Override
        public final com.microsoft.dl.video.capture.api.CameraManager createCameraManager() {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"CAMERA2:createCameraManager");
            }
            return new RealCamera2ManagerImpl();
        }
    }
}

