/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl.mock;

import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.impl.mock.MockCamera;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import java.util.concurrent.atomic.AtomicReference;

public class MockCameraImpl
implements Camera,
MockCamera {
    private static final int MESSAGE_PREVIEW_FRAME = 0;
    private final CameraCapabilities capabilities;
    private final CameraParameters parameters = new CameraParameters();
    private final EventHandler handler;
    private final Deque<byte[]> buffersPool = new ArrayDeque<byte[]>();
    private final AtomicReference<CameraCallback> callback = new AtomicReference();
    private volatile boolean isOpen = true;
    private volatile boolean isPreviewStarted;
    private final Object stateMutex = new Object();
    private Object previewDisplay;

    public MockCameraImpl(CameraCapabilities capabilities) throws CaptureException {
        this.capabilities = capabilities;
        this.handler = new EventHandler(this);
        this.parameters.setImageFormat(this.capabilities.getSupportedImageFormats().iterator().next());
        this.parameters.setResolution(this.capabilities.getSupportedResolutions().iterator().next());
        this.parameters.setFpsRange(this.capabilities.getSupportedFpsRanges().iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CameraParameters getParameters() throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            return this.parameters.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setParameters(CameraParameters parameters) throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (this.isPreviewStarted) {
                throw new CaptureException("Can not set parameters during the capturing", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (!this.capabilities.getSupportedImageFormats().contains((Object)parameters.getImageFormat())) {
                throw new CaptureException("Image format " + (Object)((Object)parameters.getImageFormat()) + " is not supported", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (!this.capabilities.getSupportedResolutions().contains(parameters.getResolution())) {
                throw new CaptureException("Resolution " + parameters.getResolution() + " is not supported", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (!this.capabilities.getSupportedFpsRanges().contains(parameters.getFpsRange())) {
                throw new CaptureException("FPS range " + parameters.getFpsRange() + " is not supported", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.parameters.setImageFormat(parameters.getImageFormat());
            this.parameters.setResolution(parameters.getResolution());
            this.parameters.setFpsRange(parameters.getFpsRange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFlashTorchMode(boolean torchTurnOn) throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.parameters.setFlashTorchMode(torchTurnOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPreviewDisplay(Object display) throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (this.isPreviewStarted) {
                throw new CaptureException("Can not set preview display during the capturing", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.previewDisplay = display;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDisplayOrientation(int degrees) throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (this.isPreviewStarted) {
                throw new CaptureException("Can not set display orientation during the capturing", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
        }
    }

    @Override
    public Matrix getFaceTransferMatrix() {
        return new Matrix();
    }

    @Override
    public void enableFaceDetection(boolean enableFaceDetection) throws CaptureException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCallbackBuffer(byte[] callbackBuffer) throws CaptureException {
        Deque<byte[]> deque = this.buffersPool;
        synchronized (deque) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.buffersPool.addLast(callbackBuffer);
            this.buffersPool.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCallback(CameraCallback cb, boolean usingBufferMode) throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (cb != null && this.isPreviewStarted) {
                throw new CaptureException("Can not set callack during the capturing", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (cb == null) {
                Deque<byte[]> deque = this.buffersPool;
                synchronized (deque) {
                    this.buffersPool.clear();
                }
            }
            this.callback.set(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startPreview() throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (this.isPreviewStarted) {
                throw new CaptureException("Preview was already started", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (this.previewDisplay == null) {
                throw new CaptureException("No preview display set", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.isPreviewStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopPreview() throws CaptureException {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new CaptureException("The camera is not open", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            if (!this.isPreviewStarted) {
                throw new CaptureException("Preview was not started", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            this.isPreviewStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isOpen) {
                throw new IllegalStateException("The camera is not open");
            }
            this.isOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean pushFrame(byte[] data, int timeoutMs, int delayMs) {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isPreviewStarted) {
                throw new IllegalStateException("Preview is not started");
            }
            return this.handler.sendMessageDelayed(this.handler.obtainMessage(0, timeoutMs, 0, data), delayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBuffer(int size, long timeoutUs) {
        if (this.callback.get() == null) {
            return null;
        }
        Deque<byte[]> deque = this.buffersPool;
        synchronized (deque) {
            if (this.buffersPool.isEmpty()) {
                try {
                    this.buffersPool.wait(timeoutUs);
                }
                catch (InterruptedException e) {
                    if (Log.isLoggable((String)"Video", (int)5)) {
                        Log.w((String)"Video", (String)"Interrupted", (Throwable)e);
                    }
                    return null;
                }
            }
            byte[] buffer = null;
            try {
                buffer = this.buffersPool.pop();
            }
            catch (EmptyStackException e) {
                return null;
            }
            if (buffer == null) {
                return null;
            }
            if (buffer.length < size) {
                throw new RuntimeException("Insuficient buffer size: " + buffer.length + " instead of " + size);
            }
            return buffer;
        }
    }

    private boolean onFrame(byte[] srcData, long timeoutMs) {
        byte[] frameBuffer = this.getBuffer(srcData.length, timeoutMs);
        if (frameBuffer == null) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Could not get the buffer for " + srcData.length + " bytes in " + timeoutMs + " ms. Skipping the frame."));
            }
            return false;
        }
        System.arraycopy(srcData, 0, frameBuffer, 0, Math.min(srcData.length, frameBuffer.length));
        CameraCallback cb = this.callback.get();
        if (!this.isOpen || !this.isPreviewStarted || cb == null) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)"The camera is not ready to process the frame. Skipping.");
            }
            return false;
        }
        cb.onCpuFrameCaptured(frameBuffer, this);
        return true;
    }

    private static class EventHandler
    extends Handler {
        private final MockCameraImpl camera;

        public EventHandler(MockCameraImpl camera) throws CaptureException {
            super(EventHandler.obtainLooper());
            this.camera = camera;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    byte[] srcData = (byte[])msg.obj;
                    long timeoutMs = msg.arg1;
                    this.camera.onFrame(srcData, timeoutMs);
                    break;
                }
                default: {
                    if (!Log.isLoggable((String)"Video", (int)6)) break;
                    Log.e((String)"Video", (String)("Unknown message " + msg));
                }
            }
        }

        private static Looper obtainLooper() throws CaptureException {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new CaptureException("No looper created for this thread", ErrorCode.ANDROID_MOCK_CAMERA_FAILED);
            }
            return looper;
        }
    }
}

