/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.microsoft.dl.utils.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class TextureRender {
    private int UNIFORM_STEXTURE = 0;
    private int UNIFORM_TARGETMATRIX = 1;
    private int UNIFORM_SOURCEMATRIX = 2;
    private int UNIFORM_FRAMESIZE = 3;
    private int NUM_UNIFORMS = 4;
    private final int BYTES_PER_FLOAT = 4;
    private FloatBuffer vertexBuffer;
    private final String[] uniformsName = new String[]{"sTexture", "uTargetMatrix", "uSourceMatrix", "frameSize"};
    private final String attribName = "aPosition";
    private final String kOes2RgbFsh = "#extension GL_OES_EGL_image_external : require\n#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main()\n{gl_FragColor = texture2D(sTexture, vTextureCoord);}";
    private final String kDrawViewPortVsh = "#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\nattribute vec2 aPosition;\nuniform vec4 frameSize;\nuniform mat2 uSourceMatrix;\nuniform mat2 uTargetMatrix;\nvarying  vec2 vTextureCoord;\nvoid main(){\nvTextureCoord = frameSize.xy+((aPosition*uSourceMatrix+1.0)/2.0*frameSize.zw);\ngl_Position = vec4(aPosition*uTargetMatrix,0.,1.);}";
    private final float[] rectCoords = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private final float[] iMat0 = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] iMat90 = new float[]{0.0f, -1.0f, 1.0f, 0.0f};
    private final float[] iMat180 = new float[]{-1.0f, 0.0f, 0.0f, -1.0f};
    private final float[] iMat270 = new float[]{0.0f, 1.0f, -1.0f, 0.0f};
    private final float[] iMatFlip = new float[]{1.0f, 0.0f, 0.0f, -1.0f};
    private GLProgram oes2RgbProgram;
    private EGLContext glContext = EGL14.EGL_NO_CONTEXT;
    private int ATTRIB_VERTEX = 0;

    public void deInitGL() {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("deInitGL: program: " + this.oes2RgbProgram.program));
        }
        if (this.oes2RgbProgram.program != 0) {
            GLES20.glDeleteProgram((int)this.oes2RgbProgram.program);
            this.oes2RgbProgram.program = 0;
            this.glContext = EGL14.EGL_NO_CONTEXT;
        }
    }

    private boolean initGL() {
        this.CreateGLProgram(1, "#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\nattribute vec2 aPosition;\nuniform vec4 frameSize;\nuniform mat2 uSourceMatrix;\nuniform mat2 uTargetMatrix;\nvarying  vec2 vTextureCoord;\nvoid main(){\nvTextureCoord = frameSize.xy+((aPosition*uSourceMatrix+1.0)/2.0*frameSize.zw);\ngl_Position = vec4(aPosition*uTargetMatrix,0.,1.);}", 1, "#extension GL_OES_EGL_image_external : require\n#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main()\n{gl_FragColor = texture2D(sTexture, vTextureCoord);}", "aPosition", this.NUM_UNIFORMS, this.uniformsName, this.oes2RgbProgram);
        if (this.oes2RgbProgram.program == 0) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"oes2RgbProgram program compilation failed!");
            }
            return false;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(32);
        bb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = bb.asFloatBuffer();
        this.vertexBuffer.put(this.rectCoords);
        this.vertexBuffer.position(0);
        this.glContext = EGL14.eglGetCurrentContext();
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("initGL succeeded with program: " + this.oes2RgbProgram.program + " glContext:" + this.glContext));
        }
        return true;
    }

    private boolean glueLinkProgram(int program) {
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            String error = GLES20.glGetProgramInfoLog((int)program);
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Failed to link program program:" + program + "linkStatus[0]: " + linkStatus[0] + " error:" + error));
            }
            return false;
        }
        return true;
    }

    private int glueCompileShader(int target, String sources) {
        int shader = 0;
        shader = GLES20.glCreateShader((int)target);
        GLES20.glShaderSource((int)shader, (String)sources);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            String error = GLES20.glGetShaderInfoLog((int)shader);
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Failed Compile Shader target:" + target + " error:" + error));
            }
        }
        return shader;
    }

    public boolean isNewContext() {
        if (this.glContext.equals((Object)EGL14.eglGetCurrentContext())) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)("false: glContext[" + this.glContext + "] is same as current context[" + EGL14.eglGetCurrentContext() + "]"));
            }
            return false;
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("True: glContext[" + this.glContext + "] is different than current context[" + EGL14.eglGetCurrentContext() + "]"));
        }
        return true;
    }

    public TextureRender() {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"creating new TextureRender");
        }
        this.oes2RgbProgram = new GLProgram();
        this.initGL();
    }

    private boolean CreateGLProgram(int numVertSources, String vertSource, int numFragSources, String fragSource, String attribName, int uniformNameCt, String[] uniformNames, GLProgram pg) {
        pg.program = GLES20.glCreateProgram();
        int vertShader = this.glueCompileShader(35633, vertSource);
        int fragShader = this.glueCompileShader(35632, fragSource);
        GLES20.glAttachShader((int)pg.program, (int)vertShader);
        GLES20.glAttachShader((int)pg.program, (int)fragShader);
        boolean status = this.glueLinkProgram(pg.program);
        if (!status && pg.program != 0) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Failed to link program: " + pg.program + " deleting program"));
            }
            GLES20.glDeleteProgram((int)pg.program);
            pg.program = 0;
        }
        if (status) {
            pg.attribs = GLES20.glGetAttribLocation((int)pg.program, (String)attribName);
            for (int i = 0; i < uniformNameCt; ++i) {
                pg.uniforms[i] = GLES20.glGetUniformLocation((int)pg.program, (String)uniformNames[i]);
            }
        }
        if (vertShader != 0) {
            GLES20.glDeleteShader((int)vertShader);
        }
        if (fragShader != 0) {
            GLES20.glDeleteShader((int)fragShader);
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Create GLProgram status:" + status));
        }
        return status;
    }

    public void drawTexture(int textureTarget, int textureId, int textureWidth, int textureHeight, String cameraName, int rotation) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("draw textureTarget[" + textureTarget + "], textureId[" + textureId + "], textureWidth[" + textureWidth + "], textureHeight[" + textureHeight + "], rotation[" + rotation + "], cameraName[" + cameraName + "]"));
        }
        float[] srcMat = new float[4];
        boolean isBackCamera = cameraName.contains("BACK");
        this.makeMatrix(srcMat, isBackCamera, rotation);
        float outputAR = srcMat[0] != 0.0f ? (float)textureHeight / (float)textureWidth : (float)textureWidth / (float)textureHeight;
        float[] tMat = isBackCamera ? this.iMatFlip : this.iMat180;
        EGLSurface drawSurface = EGL14.eglGetCurrentSurface((int)12377);
        EGLDisplay display = EGL14.eglGetCurrentDisplay();
        int[] displayWidth = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)display, (EGLSurface)drawSurface, (int)12375, (int[])displayWidth, (int)0);
        int[] displayHeight = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)display, (EGLSurface)drawSurface, (int)12374, (int[])displayHeight, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)displayWidth[0], (int)displayHeight[0]);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("displayWidth[" + displayWidth[0] + "], displayHeight[" + displayHeight[0] + "]"));
        }
        GLES20.glBindTexture((int)textureTarget, (int)textureId);
        GLES20.glUseProgram((int)this.oes2RgbProgram.program);
        GLES20.glUniform1i((int)this.oes2RgbProgram.uniforms[this.UNIFORM_STEXTURE], (int)0);
        GLES20.glUniformMatrix2fv((int)this.oes2RgbProgram.uniforms[this.UNIFORM_SOURCEMATRIX], (int)1, (boolean)false, (float[])srcMat, (int)0);
        GLES20.glUniformMatrix2fv((int)this.oes2RgbProgram.uniforms[this.UNIFORM_TARGETMATRIX], (int)1, (boolean)false, (float[])tMat, (int)0);
        if (outputAR == 0.0f) {
            int[] viewport = new int[4];
            GLES20.glGetIntegerv((int)2978, (int[])viewport, (int)0);
            float f = outputAR = tMat[0] != 0.0f ? (float)viewport[3] / (float)viewport[2] : (float)viewport[2] / (float)viewport[3];
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)"outputAR is 0, Applying default viewport");
                Log.d((String)"Video", (String)("outputAR[" + outputAR + "], viewport0[" + viewport[0] + "], viewport1[" + viewport[1] + "], viewport2[" + viewport[2] + "], viewport2[" + viewport[3]));
            }
        }
        CropDim cropDim = new CropDim();
        if (srcMat[0] != 0.0f) {
            this.getFrameCrop((float)textureHeight / (float)textureWidth, outputAR, cropDim);
            GLES20.glUniform4f((int)this.oes2RgbProgram.uniforms[this.UNIFORM_FRAMESIZE], (float)cropDim.x, (float)cropDim.y, (float)cropDim.w, (float)cropDim.h);
        } else {
            this.getFrameCrop((float)textureWidth / (float)textureHeight, outputAR, cropDim);
            GLES20.glUniform4f((int)this.oes2RgbProgram.uniforms[this.UNIFORM_FRAMESIZE], (float)cropDim.y, (float)cropDim.x, (float)cropDim.h, (float)cropDim.w);
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("cropDim.x[" + cropDim.x + "], cropDim.y[" + cropDim.y + "], cropDim.w[" + cropDim.w + "], cropDim.h:" + cropDim.h + "]"));
        }
        GLES20.glVertexAttribPointer((int)this.ATTRIB_VERTEX, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.oes2RgbProgram.attribs);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.oes2RgbProgram.attribs);
    }

    private void copyMat(float[] src, float[] dest) {
        for (int i = 0; i < 4; ++i) {
            dest[i] = src[i];
        }
    }

    private void makeMatrix(float[] mat, boolean isBackCamera, int rotation) {
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("provided rotation is:" + rotation + ", isBackCamera:" + isBackCamera));
        }
        if (isBackCamera) {
            rotation = (360 - rotation) % 360;
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)("camera is BACK, recalculated rotation is:" + rotation));
            }
        }
        if (rotation == 90) {
            this.copyMat(this.iMat90, mat);
        } else if (rotation == 180) {
            this.copyMat(this.iMat180, mat);
        } else if (rotation == 270) {
            this.copyMat(this.iMat270, mat);
        } else {
            this.copyMat(this.iMat0, mat);
        }
    }

    private void getFrameCrop(float srcAR, float targetAR, CropDim cropDim) {
        if (targetAR < srcAR) {
            cropDim.h = targetAR / srcAR;
            cropDim.w = 1.0f;
        } else {
            cropDim.w = srcAR / targetAR;
            cropDim.h = 1.0f;
        }
        cropDim.x = (1.0f - cropDim.w) / 2.0f;
        cropDim.y = (1.0f - cropDim.h) / 2.0f;
    }

    private class CropDim {
        public float x = 0.0f;
        public float y = 0.0f;
        public float w = 0.0f;
        public float h = 0.0f;
    }

    private class GLProgram {
        public int program;
        public int attribs = 0;
        public int[] uniforms;

        public GLProgram() {
            this.uniforms = new int[TextureRender.this.NUM_UNIFORMS];
            this.program = 0;
        }
    }
}

