/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.os.Debug;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LeakChecker {
    private static final String TAG = "rt::";
    private static final int maxLines = 3;
    private static Pattern m_p0 = Pattern.compile(".*?JNI local reference table has no entries.*");
    private static Pattern m_p1 = Pattern.compile(".*?JNI local reference table.*");
    private static Pattern m_p2 = Pattern.compile(".*?Last \\d+ entries \\(of (\\d+)\\):.*");
    private static Pattern m_p1summary = Pattern.compile(".*?JNI local reference table summary.*");
    private static Pattern m_p2summary = Pattern.compile(".*Summary:$");
    private static Pattern m_p3dumpend = Pattern.compile(".*JNI dump end: .*");
    private static Pattern m_p1old = Pattern.compile(".*?Last (\\d+) entries in JNI local reference table.*");
    private static Pattern m_p1n = Pattern.compile(".*?JNI local reference table \\(0x(\\d|[a-zA-Z])+\\) dump:.*");
    private static Pattern m_p1m = Pattern.compile(".*?local reference table dump:.*");
    private static Pattern m_p2n = Pattern.compile(".*?Last \\d+ entries \\(of \\d\\):.*");
    private static Pattern m_p2nempty = Pattern.compile(".*?\\(empty\\).*");
    private static Pattern m_p3 = Pattern.compile(".*?(\\d+:)\\s+0x[\\dabcdef]+\\s+(.*)");
    private Stack<ArrayDeque<String>> logStack = new Stack();

    public boolean dumpReferenceTables() {
        boolean rc = true;
        try {
            Method m = Debug.class.getDeclaredMethod("dumpReferenceTables", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
            m.setAccessible(false);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)"Failed to call dumpReferenceTables");
            rc = false;
        }
        return rc;
    }

    public void extractLocalReferenceTableFromLog(BufferedReader bufferedReader) {
        try {
            String line;
            ArrayDeque<String> dump = new ArrayDeque<String>();
            dump.offer("-1");
            boolean inspectLine = false;
            int interveningLinesCount = 0;
            block2: while ((line = bufferedReader.readLine()) != null) {
                Matcher m2;
                if (m_p0.matcher(line).matches()) {
                    dump = new ArrayDeque();
                    dump.offer("Empty local refs table");
                    continue;
                }
                if (m_p1summary.matcher(line).matches() || m_p2summary.matcher(line).matches() || m_p3dumpend.matcher(line).matches()) {
                    inspectLine = false;
                    continue;
                }
                if (m_p1old.matcher(line).matches()) {
                    dump = new ArrayDeque();
                    inspectLine = true;
                    interveningLinesCount = 3;
                    continue;
                }
                if (m_p1n.matcher(line).matches() || m_p1m.matcher(line).matches()) {
                    dump = new ArrayDeque();
                    for (int i = 3; i > 0; --i) {
                        line = bufferedReader.readLine();
                        m2 = m_p2nempty.matcher(line);
                        if (m2.matches()) {
                            dump.offer("Empty local refs table");
                            continue block2;
                        }
                        m2 = m_p2n.matcher(line);
                        if (m2.matches()) {
                            inspectLine = true;
                            interveningLinesCount = 3;
                            continue block2;
                        }
                        Log.v((String)TAG, (String)("A: Failed to match line: " + line));
                    }
                    continue;
                }
                if (m_p1.matcher(line).matches()) {
                    dump = new ArrayDeque();
                    inspectLine = true;
                    interveningLinesCount = 3;
                    for (int i = 3; i > 0 && !(m2 = m_p2.matcher(line = bufferedReader.readLine())).matches(); --i) {
                        Log.v((String)TAG, (String)("B: Failed to match line: " + line));
                    }
                    continue;
                }
                if (!inspectLine) continue;
                Matcher m3 = m_p3.matcher(line);
                if (!m3.matches()) {
                    Log.v((String)TAG, (String)("-- LEAKCHECK count = " + String.valueOf(interveningLinesCount) + ", intervening line: " + line));
                    if (interveningLinesCount-- > 0) continue;
                    inspectLine = false;
                    continue;
                }
                dump.offer(m3.group(1) + " " + m3.group(2));
                interveningLinesCount = 3;
            }
            this.logStack.push(dump);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String popAndCompareLatestDumps() {
        String s0;
        if (this.logStack.size() < 2) {
            return "BAD: logStack.size() < 2\n";
        }
        ArrayDeque<String> d1 = this.logStack.pop();
        ArrayDeque<String> d0 = this.logStack.pop();
        if (d1.size() != d0.size()) {
            String s02;
            StringBuilder sb = new StringBuilder();
            sb.append("BAD: dump sizes mismatch\n-- Dump 1:\n");
            while ((s02 = d0.poll()) != null) {
                sb.append(s02 + "\n");
            }
            sb.append("-- Dump 2:\n");
            while ((s02 = d1.poll()) != null) {
                sb.append(s02 + "\n");
            }
            sb.append("-- End dumps\n");
            return sb.toString();
        }
        StringBuilder sb0 = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        boolean failed = false;
        while ((s0 = d0.poll()) != null) {
            String s1 = d1.poll();
            sb0.append(s0);
            sb1.append(s1);
            if (s0.equals(s1)) continue;
            failed = true;
        }
        if (!failed) {
            return "GOOD: No local reference leaks";
        }
        return "BAD: dump lines mismatch\n-- Dump 1:\n" + sb0.toString() + "\n-- Dump 2:\n" + sb1.toString() + "\n-- End dumps\n";
    }
}

