/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.markuputils;

import com.aventstack.extentreports.markuputils.CodeLanguage;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupTemplate;
import com.google.gson.Gson;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

class CodeBlock
extends MarkupTemplate
implements Markup {
    private static final long serialVersionUID = -5532095355983830164L;
    private static final AtomicInteger id = new AtomicInteger(0);
    private static final String CODEBLOCK_TEMPLATE = "codeblock.ftl";
    private static final String CODEBLOCK_JSON_TEMPLATE = "codeblock.json.ftl";
    private static Template codeblock;
    private static Template codeblockJson;
    private String[] codeArray;
    private CodeLanguage lang;
    private Object jsonObject;

    @Override
    public String getMarkup() {
        if (this.jsonObject == null && this.codeArray == null) {
            return "";
        }
        if (this.jsonObject != null) {
            this.codeArray = new String[]{new Gson().toJson(this.jsonObject)};
        }
        int index = 0;
        Template t = codeblock;
        if (this.lang == CodeLanguage.JSON) {
            index = id.getAndIncrement();
            t = codeblockJson;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", this.codeArray);
        map.put("index", index);
        try {
            return ft.getSource(t, map);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Generated
    public static CodeBlockBuilder builder() {
        return new CodeBlockBuilder();
    }

    @Generated
    public String[] getCodeArray() {
        return this.codeArray;
    }

    @Generated
    public CodeLanguage getLang() {
        return this.lang;
    }

    @Generated
    public Object getJsonObject() {
        return this.jsonObject;
    }

    @Generated
    public CodeBlock(String[] codeArray, CodeLanguage lang, Object jsonObject) {
        this.codeArray = codeArray;
        this.lang = lang;
        this.jsonObject = jsonObject;
    }

    @Generated
    public String toString() {
        return "CodeBlock(codeArray=" + Arrays.deepToString(this.getCodeArray()) + ", lang=" + (Object)((Object)this.getLang()) + ", jsonObject=" + this.getJsonObject() + ")";
    }

    static {
        try {
            codeblock = ft.createTemplate(CODEBLOCK_TEMPLATE);
            codeblockJson = ft.createTemplate(CODEBLOCK_JSON_TEMPLATE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public static class CodeBlockBuilder {
        @Generated
        private String[] codeArray;
        @Generated
        private CodeLanguage lang;
        @Generated
        private Object jsonObject;

        @Generated
        CodeBlockBuilder() {
        }

        @Generated
        public CodeBlockBuilder codeArray(String[] codeArray) {
            this.codeArray = codeArray;
            return this;
        }

        @Generated
        public CodeBlockBuilder lang(CodeLanguage lang) {
            this.lang = lang;
            return this;
        }

        @Generated
        public CodeBlockBuilder jsonObject(Object jsonObject) {
            this.jsonObject = jsonObject;
            return this;
        }

        @Generated
        public CodeBlock build() {
            return new CodeBlock(this.codeArray, this.lang, this.jsonObject);
        }

        @Generated
        public String toString() {
            return "CodeBlock.CodeBlockBuilder(codeArray=" + Arrays.deepToString(this.codeArray) + ", lang=" + (Object)((Object)this.lang) + ", jsonObject=" + this.jsonObject + ")";
        }
    }
}

