/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.BaseEntity;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.ReportStats;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.NamedAttributeContextManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class Report
implements Serializable,
BaseEntity {
    private static final long serialVersionUID = -8667496631392333349L;
    private Date startTime;
    private Date endTime;
    private Status status;
    private final transient ReportStats stats = new ReportStats();
    private final List<Test> testList = Collections.synchronizedList(new ArrayList());
    private final transient NamedAttributeContextManager<Author> authorCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<Category> categoryCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<Device> deviceCtx = new NamedAttributeContextManager();
    private final transient NamedAttributeContextManager<ExceptionInfo> exceptionInfoCtx = new NamedAttributeContextManager();
    private final List<String> logs = Collections.synchronizedList(new ArrayList());
    private final List<SystemEnvInfo> systemEnvInfo = new ArrayList<SystemEnvInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh() {
        this.authorCtx.getSet().forEach(x -> x.refresh());
        this.categoryCtx.getSet().forEach(x -> x.refresh());
        this.deviceCtx.getSet().forEach(x -> x.refresh());
        this.exceptionInfoCtx.getSet().forEach(x -> x.refresh());
        List<Test> list = this.testList;
        synchronized (list) {
            this.stats.update(this.testList);
            this.setEndTime(Calendar.getInstance().getTime());
        }
    }

    public void addTest(Test test) {
        this.testList.add(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTest(Test test) {
        List<Test> list = this.testList;
        synchronized (list) {
            return this.removeTest(this.testList, test);
        }
    }

    private boolean removeTest(List<Test> testList, Test test) {
        boolean removed = testList.removeIf(x -> x.getId() == test.getId());
        if (!removed) {
            testList.forEach(x -> {
                boolean bl = this.removeTest(x.getChildren(), test);
            });
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void applyOverrideConf() {
        List<Test> list = this.testList;
        synchronized (list) {
            Date min = this.testList.stream().map(t -> t.getStartTime()).min(Date::compareTo).get();
            Date max = this.testList.stream().map(t -> t.getEndTime()).max(Date::compareTo).get();
            this.setStartTime(min);
            this.setEndTime(max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBDD() {
        List<Test> list = this.testList;
        synchronized (list) {
            return !this.testList.isEmpty() && this.testList.stream().allMatch(Test::isBDD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean anyTestHasStatus(Status status) {
        List<Test> list = this.testList;
        synchronized (list) {
            return this.testList.stream().anyMatch(x -> x.getStatus() == status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Test> findTest(List<Test> list, String name) {
        List<Test> list2 = this.testList;
        synchronized (list2) {
            Iterator<Test> iterator;
            Optional<Test> test = list.stream().filter(x -> x.getName().equals(name)).findFirst();
            if (!test.isPresent() && (iterator = list.iterator()).hasNext()) {
                Test t = iterator.next();
                return this.findTest(t.getChildren(), name);
            }
            return test;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExceptionInfo> aggregateExceptions(List<Test> testList) {
        List<Test> list = testList;
        synchronized (list) {
            ArrayList<ExceptionInfo> list2 = new ArrayList<ExceptionInfo>();
            for (Test test : testList) {
                list2.addAll(test.aggregateExceptions());
                if (test.getChildren().isEmpty()) continue;
                this.aggregateExceptions(test.getChildren());
            }
            return list2;
        }
    }

    public final long timeTaken() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status getStatus() {
        List<Test> list = this.testList;
        synchronized (list) {
            List<Status> list2 = this.testList.stream().map(x -> x.getStatus()).collect(Collectors.toList());
            Status s = Status.max(list2);
            if (s == Status.SKIP && this.anyTestHasStatus(Status.PASS)) {
                s = Status.PASS;
            }
            return s;
        }
    }

    @Generated
    private static Date $default$startTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Date $default$endTime() {
        return Calendar.getInstance().getTime();
    }

    @Generated
    private static Status $default$status() {
        return Status.PASS;
    }

    @Generated
    public static ReportBuilder builder() {
        return new ReportBuilder();
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public ReportStats getStats() {
        return this.stats;
    }

    @Generated
    public List<Test> getTestList() {
        return this.testList;
    }

    @Generated
    public NamedAttributeContextManager<Author> getAuthorCtx() {
        return this.authorCtx;
    }

    @Generated
    public NamedAttributeContextManager<Category> getCategoryCtx() {
        return this.categoryCtx;
    }

    @Generated
    public NamedAttributeContextManager<Device> getDeviceCtx() {
        return this.deviceCtx;
    }

    @Generated
    public NamedAttributeContextManager<ExceptionInfo> getExceptionInfoCtx() {
        return this.exceptionInfoCtx;
    }

    @Generated
    public List<String> getLogs() {
        return this.logs;
    }

    @Generated
    public List<SystemEnvInfo> getSystemEnvInfo() {
        return this.systemEnvInfo;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public Report() {
        this.startTime = Report.$default$startTime();
        this.endTime = Report.$default$endTime();
        this.status = Report.$default$status();
    }

    @Generated
    public Report(Date startTime, Date endTime, Status status) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
    }

    @Generated
    public String toString() {
        return "Report(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + (Object)((Object)this.getStatus()) + ", stats=" + this.getStats() + ", testList=" + this.getTestList() + ", authorCtx=" + this.getAuthorCtx() + ", categoryCtx=" + this.getCategoryCtx() + ", deviceCtx=" + this.getDeviceCtx() + ", exceptionInfoCtx=" + this.getExceptionInfoCtx() + ", logs=" + this.getLogs() + ", systemEnvInfo=" + this.getSystemEnvInfo() + ")";
    }

    @Generated
    public static class ReportBuilder {
        @Generated
        private Date startTime$value;
        @Generated
        private boolean startTime$set;
        @Generated
        private Date endTime$value;
        @Generated
        private boolean endTime$set;
        @Generated
        private Status status$value;
        @Generated
        private boolean status$set;

        @Generated
        ReportBuilder() {
        }

        @Generated
        public ReportBuilder startTime(Date startTime) {
            this.startTime$value = startTime;
            this.startTime$set = true;
            return this;
        }

        @Generated
        public ReportBuilder endTime(Date endTime) {
            this.endTime$value = endTime;
            this.endTime$set = true;
            return this;
        }

        @Generated
        public ReportBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public Report build() {
            Date startTime$value = this.startTime$value;
            if (!this.startTime$set) {
                startTime$value = Report.$default$startTime();
            }
            Date endTime$value = this.endTime$value;
            if (!this.endTime$set) {
                endTime$value = Report.$default$endTime();
            }
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = Report.$default$status();
            }
            return new Report(startTime$value, endTime$value, status$value);
        }

        @Generated
        public String toString() {
            return "Report.ReportBuilder(startTime$value=" + this.startTime$value + ", endTime$value=" + this.endTime$value + ", status$value=" + (Object)((Object)this.status$value) + ")";
        }
    }
}

