/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.config.external.JsonConfigLoader;
import com.aventstack.extentreports.config.external.XmlConfigLoader;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.AbstractFileReporter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import com.aventstack.extentreports.reporter.ReporterFilterable;
import com.aventstack.extentreports.reporter.configuration.EntityFilters;
import com.aventstack.extentreports.reporter.configuration.ExtentSparkReporterConfig;
import com.aventstack.extentreports.reporter.configuration.ViewConfigurer;
import com.aventstack.extentreports.reporter.configuration.ViewsConfigurable;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public class ExtentSparkReporter
extends AbstractFileReporter
implements ReportObserver<ReportEntity>,
ReporterConfigurable,
ViewsConfigurable<ExtentSparkReporter>,
ReporterFilterable<ExtentSparkReporter> {
    private static final Logger logger = Logger.getLogger(ExtentSparkReporter.class.getName());
    private static final String TEMPLATE_LOCATION = "templates/";
    private static final String ENCODING = "UTF-8";
    private static final String REPORTER_NAME = "spark";
    private static final String SPA_TEMPLATE_NAME = "spark/spark.spa.ftl";
    private static final String FILE_NAME = "Index.html";
    private final AtomicBoolean executed = new AtomicBoolean();
    private final ViewConfigurer<ExtentSparkReporter> viewConfigurer = new ViewConfigurer<ExtentSparkReporter>(this);
    private final EntityFilters<ExtentSparkReporter> filter = new EntityFilters<ExtentSparkReporter>(this);
    private ExtentSparkReporterConfig conf = ((ExtentSparkReporterConfig.ExtentSparkReporterConfigBuilder)ExtentSparkReporterConfig.builder().reporter(this)).build();
    private Disposable disposable;
    private Report report;

    public ExtentSparkReporter(String path) {
        super(new File(path));
    }

    public ExtentSparkReporter(File f) {
        super(f);
    }

    @Override
    public EntityFilters<ExtentSparkReporter> filter() {
        return this.filter;
    }

    @Override
    public ViewConfigurer<ExtentSparkReporter> viewConfigurer() {
        return this.viewConfigurer;
    }

    public ExtentSparkReporterConfig config() {
        return this.conf;
    }

    public ExtentSparkReporter config(ExtentSparkReporterConfig conf) {
        conf.setReporter(this);
        this.conf = conf;
        return this;
    }

    @Override
    public void loadJSONConfig(File jsonFile) throws IOException {
        JsonConfigLoader<ExtentSparkReporterConfig> loader = new JsonConfigLoader<ExtentSparkReporterConfig>(this.conf, jsonFile);
        loader.apply();
    }

    @Override
    public void loadJSONConfig(String jsonString) throws IOException {
        JsonConfigLoader<ExtentSparkReporterConfig> loader = new JsonConfigLoader<ExtentSparkReporterConfig>(this.conf, jsonString);
        loader.apply();
    }

    @Override
    public void loadXMLConfig(File xmlFile) throws IOException {
        XmlConfigLoader<ExtentSparkReporterConfig> loader = new XmlConfigLoader<ExtentSparkReporterConfig>(this.conf, xmlFile);
        loader.apply();
    }

    @Override
    public void loadXMLConfig(String xmlFile) throws IOException {
        this.loadXMLConfig(new File(xmlFile));
    }

    private void executeActions() {
        if (!this.executed.get()) {
            this.conf.enableOfflineMode(this.conf.getOfflineMode());
            this.executed.compareAndSet(false, true);
        }
    }

    @Override
    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                ExtentSparkReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                ExtentSparkReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
        this.loadTemplateModel();
    }

    private void flush(ReportEntity value) {
        this.executeActions();
        this.report = this.filterAndGet(value.getReport(), this.filter.statusFilter().getStatus());
        try {
            this.getTemplateModel().put("this", this);
            this.getTemplateModel().put("viewOrder", this.viewConfigurer.viewOrder().getViewOrder());
            this.getTemplateModel().put("report", this.report);
            this.createFreemarkerConfig(TEMPLATE_LOCATION, ENCODING);
            String filePath = this.getFileNameAsExt(FILE_NAME, new String[]{".html", ".htm"});
            Template template = this.getFreemarkerConfig().getTemplate(SPA_TEMPLATE_NAME);
            this.processTemplate(template, new File(filePath));
            return;
        }
        catch (TemplateException | IOException e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
            return;
        }
    }

    @Generated
    public AtomicBoolean getExecuted() {
        return this.executed;
    }

    @Generated
    public ExtentSparkReporterConfig getConf() {
        return this.conf;
    }

    @Generated
    public Disposable getDisposable() {
        return this.disposable;
    }

    @Generated
    public Report getReport() {
        return this.report;
    }
}

