/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.context;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class NamedAttributeContext<T extends NamedAttribute>
implements Serializable {
    private static final long serialVersionUID = -2671203343283101908L;
    private final List<Test> testList = Collections.synchronizedList(new ArrayList());
    private T attr;
    private Integer passed = 0;
    private Integer failed = 0;
    private Integer skipped = 0;
    private Integer others = 0;

    public NamedAttributeContext(T attribute, Test test) {
        this.attr = attribute;
        this.addTest(test);
    }

    public void addTest(Test test) {
        if (test == null) {
            throw new IllegalArgumentException("Test cannot be null");
        }
        this.testList.add(test);
        this.refresh(test);
    }

    private synchronized void refresh(Test test) {
        if (test.getStatus() == Status.PASS) {
            Integer n = this.passed;
            Integer n2 = this.passed = Integer.valueOf(this.passed + 1);
        } else if (test.getStatus() == Status.FAIL) {
            Integer n = this.failed;
            Integer n3 = this.failed = Integer.valueOf(this.failed + 1);
        } else if (test.getStatus() == Status.SKIP) {
            Integer n = this.skipped;
            Integer n4 = this.skipped = Integer.valueOf(this.skipped + 1);
        } else {
            Integer n = this.others;
            Integer n5 = this.others = Integer.valueOf(this.others + 1);
        }
    }

    public void refresh() {
        this.skipped = this.others = Integer.valueOf(0);
        this.failed = this.others;
        this.passed = this.others;
        this.testList.forEach(this::refresh);
    }

    public Integer size() {
        return this.passed + this.failed + this.skipped + this.others;
    }

    @Generated
    public List<Test> getTestList() {
        return this.testList;
    }

    @Generated
    public T getAttr() {
        return this.attr;
    }

    @Generated
    public Integer getPassed() {
        return this.passed;
    }

    @Generated
    public Integer getFailed() {
        return this.failed;
    }

    @Generated
    public Integer getSkipped() {
        return this.skipped;
    }

    @Generated
    public Integer getOthers() {
        return this.others;
    }

    @Generated
    public String toString() {
        return "NamedAttributeContext(testList=" + this.getTestList() + ", attr=" + this.getAttr() + ", passed=" + this.getPassed() + ", failed=" + this.getFailed() + ", skipped=" + this.getSkipped() + ", others=" + this.getOthers() + ")";
    }
}

