/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.aventstack.extentreports.reporter.configuration.ExtentSparkReporterConfiguration;
import com.aventstack.extentreports.reporter.configuration.ViewStyle;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentSparkReporter
extends BasicFileReporter {
    private static final Logger logger = Logger.getLogger(ExtentSparkReporter.class.getName());
    private static final String REPORTER_NAME = "spark";
    private static final String SPA_TEMPLATE_NAME = "spark/spark.spa.ftl";
    private static final String TEST_TEMPLATE_NAME = "spark/test.ftl";
    private static final String TAG_TEMPLATE_NAME = "spark/tag.ftl";
    private static final String EXCEPTION_TEMPLATE_NAME = "spark/exception.ftl";
    private static final String DASHBOARD_TEMPLATE_NAME = "spark/dashboard.ftl";
    private static final String[] DEFAULT_CONFIG_FILE_PATH = new String[]{"spark.properties", "src/main/resources/spark.properties"};
    private ExtentSparkReporterConfiguration externalUserConfiguration = new ExtentSparkReporterConfiguration(this);
    private ViewStyle viewStyle = ViewStyle.SPA;

    public ExtentSparkReporter(String path) {
        super(path);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentSparkReporter(File file) {
        super(file);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentSparkReporter(String path, ViewStyle viewStyle) {
        this(path);
        this.setViewStyle(viewStyle);
    }

    public ExtentSparkReporter(File file, ViewStyle viewStyle) {
        this(file);
        this.setViewStyle(viewStyle);
    }

    public ExtentSparkReporterConfiguration config() {
        return this.externalUserConfiguration;
    }

    private void setViewStyle(ViewStyle viewStyle) {
        this.viewStyle = viewStyle;
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
        if (this.getTestList().isEmpty()) {
            return;
        }
        if (this.enforceOfflineMode().booleanValue()) {
            this.externalUserConfiguration.enableOfflineMode(true);
        }
        this.loadUserConfig();
        try {
            if (this.viewStyle == ViewStyle.SPA) {
                String fileName = this.getFileFile().isDirectory() ? String.valueOf(this.getDestinationPath()) + "Index.html" : this.getFilePath();
                Template template = this.getFreemarkerConfig().getTemplate(SPA_TEMPLATE_NAME);
                this.processTemplate(template, new File(fileName));
                return;
            }
            Template template = this.getFreemarkerConfig().getTemplate(TEST_TEMPLATE_NAME);
            this.processTemplate(template, new File(String.valueOf(this.getDestinationPath()) + "index.html"));
            if (!this.getCategoryContextInfo().getTestAttributeTestContext().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(TAG_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.getDestinationPath()) + "tag.html"));
            }
            if (!this.getExceptionContextInfo().getExceptionTestContext().isEmpty()) {
                template = this.getFreemarkerConfig().getTemplate(EXCEPTION_TEMPLATE_NAME);
                this.processTemplate(template, new File(String.valueOf(this.getDestinationPath()) + "exception.html"));
            }
            template = this.getFreemarkerConfig().getTemplate(DASHBOARD_TEMPLATE_NAME);
            this.processTemplate(template, new File(String.valueOf(this.getDestinationPath()) + "dashboard.html"));
        }
        catch (TemplateException | IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }

    @Override
    public String getReporterName() {
        return REPORTER_NAME;
    }
}

