/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.mediastorage;

import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class LocalMediaStorageHandler
implements MediaStorage {
    private static final Logger logger = Logger.getLogger(LocalMediaStorageHandler.class.getName());
    private String reporterGeneratedFilePath;
    private String targetPath;
    private String relativePath;

    @Override
    public void init(String reporterGeneratedFilePath) {
        this.reporterGeneratedFilePath = reporterGeneratedFilePath;
        this.mkDirs();
    }

    @Override
    public void storeMedia(Media screenCapture) throws IOException {
        this.storeMediaFileLocal(screenCapture);
    }

    private void mkDirs() {
        String ext = FileUtil.getExtension(this.reporterGeneratedFilePath);
        String archiveName = "";
        if (ext.equalsIgnoreCase("htm") || ext.equalsIgnoreCase("html")) {
            archiveName = String.valueOf(FileUtil.getFileNameWithoutExtension(this.reporterGeneratedFilePath)) + ".";
        }
        String absolutePath = new File(this.reporterGeneratedFilePath).getAbsolutePath().replace("\\", "/");
        String basePath = archiveName.isEmpty() ? absolutePath : new File(absolutePath).getParent().replace("\\", "/");
        archiveName = archiveName.isEmpty() ? (archiveName = String.valueOf(FileUtil.getFileNameWithoutExtension(this.reporterGeneratedFilePath)) + ".") : archiveName;
        this.mkDirs(basePath, archiveName, 0);
    }

    private void mkDirs(String basePath, String fileName, int cnt) {
        this.relativePath = String.valueOf(fileName) + cnt + "/";
        this.targetPath = String.valueOf(basePath) + "/" + this.relativePath;
        File f = new File(this.targetPath);
        if (!f.exists()) {
            f.mkdirs();
        } else {
            this.mkDirs(basePath, fileName, ++cnt);
        }
    }

    private void storeMediaFileLocal(Media media) throws IOException {
        String baseFileName;
        File f = new File(media.getPath());
        if (!f.exists()) {
            logger.warning("Unable to locate media file: " + media.getPath());
            return;
        }
        String mediaFileName = baseFileName = new File(media.getPath()).getName();
        String copyToPath = String.valueOf(this.targetPath) + baseFileName;
        File copyToFile = new File(copyToPath);
        int cnt = 0;
        while (copyToFile.exists()) {
            String name = String.valueOf(FileUtil.getFileNameWithoutExtension(baseFileName)) + "." + cnt;
            String ext = FileUtil.getExtension(baseFileName);
            mediaFileName = String.valueOf(name) + "." + ext;
            copyToPath = String.valueOf(this.targetPath) + mediaFileName + "/";
            copyToFile = new File(copyToPath);
            ++cnt;
        }
        Path p = Paths.get(copyToPath, new String[0]);
        Files.copy(new FileInputStream(f), p, new CopyOption[0]);
        media.setPath(String.valueOf(this.relativePath) + mediaFileName);
    }
}

