/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExtentObservable;
import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.ReportConfigurator;
import com.aventstack.extentreports.ReportStatusStats;
import com.aventstack.extentreports.gherkin.GherkinDialectProvider;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.SystemAttribute;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class ExtentReports
extends ExtentObservable {
    @Override
    public void attachReporter(ExtentReporter ... reporter) {
        Arrays.stream(reporter).forEach(this::register);
    }

    public List<ExtentReporter> getStartedReporters() {
        return this.getReporterCollection();
    }

    public synchronized ExtentTest createTest(Class<? extends IGherkinFormatterModel> type, String testName, String description) {
        ExtentTest t = new ExtentTest(this, type, testName, description);
        this.applyCommonTestSettings(t);
        this.saveTest(t.getModel());
        return t;
    }

    public synchronized ExtentTest createTest(Class<? extends IGherkinFormatterModel> type, String testName) {
        return this.createTest(type, testName, null);
    }

    public synchronized ExtentTest createTest(GherkinKeyword gherkinKeyword, String testName, String description) {
        Class<?> clazz = gherkinKeyword.getKeyword().getClass();
        return this.createTest(clazz, testName, description);
    }

    public synchronized ExtentTest createTest(GherkinKeyword gherkinKeyword, String testName) {
        return this.createTest(gherkinKeyword, testName, null);
    }

    public synchronized ExtentTest createTest(String testName, String description) {
        ExtentTest t = new ExtentTest(this, testName, description);
        this.applyCommonTestSettings(t);
        this.saveTest(t.getModel());
        return t;
    }

    public synchronized ExtentTest createTest(String testName) {
        return this.createTest(testName, null);
    }

    private synchronized void applyCommonTestSettings(ExtentTest extentTest) {
        extentTest.setUseManualConfiguration(this.getAllowManualConfig());
    }

    public synchronized void removeTest(ExtentTest test) {
        super.removeTest(test.getModel());
    }

    @Override
    public synchronized void flush() {
        super.flush();
    }

    public void setSystemInfo(String k, String v) {
        SystemAttribute sa = new SystemAttribute(k, v);
        super.setSystemInfo(sa);
    }

    public void setTestRunnerOutput(List<String> log) {
        log.forEach(this::setTestRunnerLogs);
    }

    public void setTestRunnerOutput(String log) {
        this.setTestRunnerLogs(log);
    }

    public void setReportUsesManualConfiguration(boolean useManualConfig) {
        this.setAllowManualConfig(useManualConfig);
    }

    @Override
    public void setAnalysisStrategy(AnalysisStrategy strategy) {
        super.setAnalysisStrategy(strategy);
    }

    public ReportConfigurator config() {
        return ReportConfigurator.getInstance();
    }

    public void setGherkinDialect(String language) throws UnsupportedEncodingException {
        GherkinDialectProvider.setLanguage(language);
    }

    @Override
    public ReportStatusStats getStats() {
        return super.getStats();
    }
}

