/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter.configuration;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.ExtentLoggerReporter;
import com.aventstack.extentreports.reporter.configuration.BasicFileConfiguration;
import com.aventstack.extentreports.reporter.configuration.IReporterConfiguration;
import com.aventstack.extentreports.reporter.configuration.Protocol;
import com.aventstack.extentreports.reporter.configuration.Theme;
import com.aventstack.extentreports.resource.OfflineResxDelegate;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.util.stream.Stream;

public class ExtentLoggerFormatterConfiguration
extends BasicFileConfiguration
implements IReporterConfiguration {
    private Protocol protocol;
    private Theme theme;

    public ExtentLoggerFormatterConfiguration(AbstractReporter reporter) {
        super(reporter);
    }

    public void setProtocol(Protocol protocol) {
        this.usedConfigs.put("protocol", String.valueOf((Object)protocol).toLowerCase());
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setTheme(Theme theme) {
        this.usedConfigs.put("theme", String.valueOf((Object)theme).toLowerCase());
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setAutoCreateRelativePathMedia(boolean v) {
        this.usedConfigs.put("autoCreateRelativePathMedia", String.valueOf(v));
    }

    public void enableOfflineMode(Boolean offline) {
        this.usedConfigs.put("enableOfflineMode", String.valueOf(offline));
        this.usedConfigs.put("offlineDirectory", String.valueOf(this.getReporter().getReporterName()) + "/");
        if (offline.booleanValue()) {
            File f = this.getTargetDirectory(((ExtentLoggerReporter)this.getReporter()).getFileFile());
            String s = "/";
            String resourcePackagePath = ExtentReports.class.getPackage().getName().replace(".", s);
            resourcePackagePath = String.valueOf(resourcePackagePath) + s + "offline" + s;
            String[] resx = this.combine(this.getJSFiles(), this.getCSSFiles(), this.getIconFiles(), this.getImgFiles());
            OfflineResxDelegate.saveOfflineResources(resourcePackagePath, resx, f.getAbsolutePath());
        }
    }

    private File getTargetDirectory(File f) {
        String dir;
        if (FileUtil.isDirectory(f).booleanValue()) {
            dir = f.getAbsolutePath().replace("\\", "/");
        } else {
            dir = f.getAbsolutePath().replace("\\", "/");
            dir = new File(dir).getParent();
        }
        dir = String.valueOf(dir) + "/" + this.getReporter().getReporterName();
        return new File(dir);
    }

    private String[] combine(String[] ... array) {
        String[] result = new String[]{};
        String[][] stringArray2 = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arr = stringArray2[n2];
            result = (String[])Stream.of(result, arr).flatMap(stringArray -> Stream.of(stringArray)).toArray(String[]::new);
            ++n2;
        }
        return result;
    }

    private String[] getJSFiles() {
        String commonsPath = "commons/js/";
        String reporterPath = String.valueOf(this.getReporter().getReporterName()) + "/js/";
        String[] files = new String[]{String.valueOf(commonsPath) + "attr.js", String.valueOf(commonsPath) + "dashboard.js", String.valueOf(reporterPath) + "logger-scripts.js"};
        return files;
    }

    private String[] getCSSFiles() {
        String stylesPath = "css/";
        String reporterPath = String.valueOf(this.getReporter().getReporterName()) + "/" + stylesPath + "/";
        String[] files = new String[]{String.valueOf(reporterPath) + "logger-style.css"};
        return files;
    }

    private String[] getIconFiles() {
        String path = "commons/css/icons/";
        String iconDirPath = "fontawesome/";
        String[] files = new String[]{String.valueOf(path) + "font-awesome.min.css", String.valueOf(path) + iconDirPath + "fontawesome-webfont.eot", String.valueOf(path) + iconDirPath + "fontawesome-webfont.svg", String.valueOf(path) + iconDirPath + "fontawesome-webfont.ttf", String.valueOf(path) + iconDirPath + "fontawesome-webfont.woff", String.valueOf(path) + iconDirPath + "fontawesome-webfont.woff2", String.valueOf(path) + iconDirPath + "FontAwesome.otf"};
        return files;
    }

    private String[] getImgFiles() {
        String path = "commons/img/";
        String[] files = new String[]{String.valueOf(path) + "logo.png"};
        return files;
    }
}

