/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.RunResult;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.AbstractStructure;
import com.aventstack.extentreports.model.BasicMongoReportElement;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.TestAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.types.ObjectId;

public class Test
implements BasicMongoReportElement,
RunResult,
Serializable {
    private static final long serialVersionUID = 5590943223572254960L;
    private static final AtomicInteger atomicInt = new AtomicInteger(0);
    private transient ExtentReports extent;
    private int level = 0;
    private int testId = atomicInt.incrementAndGet();
    private Test parent;
    private Status status = Status.PASS;
    private AbstractStructure<Test> node;
    private AbstractStructure<Log> log;
    private AbstractStructure<TestAttribute> category;
    private AbstractStructure<TestAttribute> author;
    private AbstractStructure<TestAttribute> device;
    private Date startTime = Calendar.getInstance().getTime();
    private Date endTime = Calendar.getInstance().getTime();
    private ObjectId mongoId;
    private Class<? extends IGherkinFormatterModel> bddType;
    private transient List<ScreenCapture> screenCaptureList;
    private transient List<Screencast> screencastList;
    private transient List<ExceptionInfo> exceptionList;
    private String name;
    private String hierarchicalName;
    private String description;
    private boolean ended = false;
    private boolean usesManualConfiguration = false;

    public void setUseManualConfiguration(boolean b) {
        this.usesManualConfiguration = b;
    }

    public ExtentReports getExtentInstance() {
        return this.extent;
    }

    public void setExtentInstance(ExtentReports extent) {
        this.extent = extent;
    }

    public boolean isChildNode() {
        return this.level > 0;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setParent(Test parent) {
        this.parent = parent;
    }

    public Test getParent() {
        return this.parent;
    }

    public AbstractStructure<Test> getNodeContext() {
        if (this.node == null) {
            this.node = new AbstractStructure();
        }
        return this.node;
    }

    public boolean hasChildren() {
        return this.node != null && this.node.getAll() != null && this.node.getAll().size() > 0;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    private void setEndTimeFromChildren() {
        if (this.hasLog()) {
            int logSize = this.getLogContext().size();
            Date lastLogEndTime = this.getLogContext().get(logSize - 1).getTimestamp();
            this.setEndTime(lastLogEndTime);
        }
        if (this.hasChildren()) {
            int nodeSize = this.getNodeContext().size();
            Date lastNodeEndTime = this.getNodeContext().get(nodeSize - 1).getEndTime();
            this.setEndTime(lastNodeEndTime);
        }
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public String getRunDuration() {
        long diff = this.endTime.getTime() - this.startTime.getTime();
        long secs = diff / 1000L;
        long millis = diff % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return String.valueOf(hours) + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + millis + "ms";
    }

    public Long getRunDurationMillis() {
        long diff = this.endTime.getTime() - this.startTime.getTime();
        return diff;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void trackLastRunStatus() {
        this.getLogContext().getAll().forEach(x -> this.updateStatus(x.getStatus()));
        this.status = this.status == Status.INFO || this.status == Status.DEBUG ? Status.PASS : this.status;
    }

    private synchronized void updateStatus(Status logStatus) {
        int testStatusIndex;
        int logStatusIndex = Status.getStatusHierarchy().indexOf(logStatus);
        this.status = logStatusIndex < (testStatusIndex = Status.getStatusHierarchy().indexOf(this.status)) ? logStatus : this.status;
    }

    public void end() {
        this.updateTestStatusRecursive(this);
        this.endChildrenRecursive(this);
        Status status = this.status = this.status == Status.INFO || this.status == Status.DEBUG ? Status.PASS : this.status;
        if (!this.usesManualConfiguration || this.endTime == null) {
            this.setEndTimeFromChildren();
        }
    }

    private synchronized void updateTestStatusRecursive(Test test) {
        test.getLogContext().getAll().forEach(x -> this.updateStatus(x.getStatus()));
        if (test.hasChildren()) {
            test.getNodeContext().getAll().forEach(this::updateTestStatusRecursive);
        }
        if (!test.isBehaviorDrivenType()) {
            boolean hasNodeNotSkipped = test.getNodeContext().getAll().stream().anyMatch(x -> x.getStatus() != Status.SKIP);
            if (this.status == Status.SKIP && hasNodeNotSkipped) {
                this.status = Status.PASS;
                test.getNodeContext().getAll().stream().filter(x -> x.getStatus() != Status.SKIP).forEach(this::updateTestStatusRecursive);
            }
        }
    }

    private void endChildrenRecursive(Test test) {
        test.getNodeContext().getAll().forEach(Test::end);
    }

    public AbstractStructure<Log> getLogContext() {
        if (this.log == null) {
            this.log = new AbstractStructure();
        }
        return this.log;
    }

    public boolean hasLog() {
        return this.log != null && !this.log.isEmpty();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getHierarchicalName() {
        this.hierarchicalName = this.parent == null ? this.name : String.join((CharSequence)".", this.parent.getHierarchicalName(), this.getName());
        return this.hierarchicalName;
    }

    public AbstractStructure<TestAttribute> getCategoryContext() {
        if (this.category == null) {
            this.category = new AbstractStructure();
        }
        return this.category;
    }

    public boolean hasCategory(String name) {
        return this.hasCategory() && this.category.getAll().stream().anyMatch(x -> x.getName().equals(name));
    }

    public boolean hasCategoryNode(String name) {
        return this.getNodeContext().getAll().stream().anyMatch(x -> x.hasCategory(name));
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public void setCategory(TestAttribute category) {
        this.getCategoryContext().add(category);
    }

    public TestAttribute getCategory(Integer index) {
        if (this.hasCategory() && index < this.category.size()) {
            return this.category.get(index);
        }
        return null;
    }

    public AbstractStructure<TestAttribute> getAuthorContext() {
        if (this.author == null) {
            this.author = new AbstractStructure();
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public void setAuthor(TestAttribute author) {
        this.getAuthorContext().add(author);
    }

    public TestAttribute getAuthor(Integer index) {
        if (this.hasAuthor() && index < this.author.size()) {
            return this.author.get(index);
        }
        return null;
    }

    public AbstractStructure<TestAttribute> getDeviceContext() {
        if (this.device == null) {
            this.device = new AbstractStructure();
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public void setDevice(TestAttribute device) {
        this.getDeviceContext().add(device);
    }

    public TestAttribute getDevice(Integer index) {
        if (this.hasDevice() && index < this.author.size()) {
            return this.device.get(index);
        }
        return null;
    }

    public void setExceptionInfo(ExceptionInfo exceptionInfo) {
        if (this.exceptionList == null) {
            this.exceptionList = new ArrayList<ExceptionInfo>();
        }
        this.exceptionList.add(exceptionInfo);
    }

    public List<ExceptionInfo> getExceptionInfoList() {
        return this.exceptionList;
    }

    public boolean hasException() {
        return this.exceptionList != null && !this.exceptionList.isEmpty();
    }

    public boolean hasMedia() {
        return this.screenCaptureList != null && !this.screenCaptureList.isEmpty() && this.screencastList != null && !this.screencastList.isEmpty();
    }

    public void setScreenCapture(ScreenCapture screenCapture) {
        if (this.screenCaptureList == null) {
            this.screenCaptureList = new ArrayList<ScreenCapture>();
        }
        this.screenCaptureList.add(screenCapture);
    }

    public List<ScreenCapture> getScreenCaptureList() {
        return this.screenCaptureList;
    }

    public Boolean hasScreenCapture() {
        if (this.screenCaptureList != null && !this.screenCaptureList.isEmpty()) {
            return true;
        }
        return false;
    }

    public void setScreencast(Screencast screencast) {
        if (this.screencastList == null) {
            this.screencastList = new ArrayList<Screencast>();
        }
        this.screencastList.add(screencast);
    }

    public List<Screencast> getScreencastList() {
        return this.screencastList;
    }

    public boolean isBehaviorDrivenType() {
        return this.bddType != null;
    }

    public void setBehaviorDrivenType(IGherkinFormatterModel type) {
        this.bddType = type.getClass();
    }

    public void setBehaviorDrivenType(Class<? extends IGherkinFormatterModel> type) {
        this.bddType = type;
    }

    public Class<? extends IGherkinFormatterModel> getBehaviorDrivenType() {
        return this.bddType;
    }

    void setID(int id) {
        this.testId = id;
    }

    public int getID() {
        return this.testId;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.mongoId = id;
    }

    @Override
    public ObjectId getObjectId() {
        return this.mongoId;
    }
}

