/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.LogStructure;
import com.aventstack.extentreports.model.NodeStructure;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.TestAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.types.ObjectId;

public class Test
implements Serializable {
    static final long serialVersionUID = 5590943223572254960L;
    private int level = 0;
    private Test parent;
    private Status testStatus;
    private NodeStructure node;
    private LogStructure log;
    private Date endTime;
    private Date startTime;
    private int testID;
    private static final AtomicInteger id = new AtomicInteger(0);
    private ObjectId mongoId;
    private Class<? extends IGherkinFormatterModel> bddType;
    private transient List<ScreenCapture> scList;
    private transient List<ExceptionInfo> exceptionList;
    private transient List<TestAttribute> authorList;
    private transient List<TestAttribute> categoryList;
    private String name;
    private String hierarchicalName;
    private String description;
    private boolean ended = false;

    public Test() {
        this.setStartTime(Calendar.getInstance().getTime());
        this.setStatus(Status.UNKNOWN);
        this.setID(id.incrementAndGet());
    }

    public boolean isChildNode() {
        return this.level > 0;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setParent(Test parent) {
        this.hierarchicalName = parent.getHierarchicalName() + "." + this.getName();
        this.parent = parent;
    }

    public Test getParent() {
        return this.parent;
    }

    public NodeStructure getNodeContext() {
        if (this.node == null) {
            this.node = new NodeStructure();
        }
        return this.node;
    }

    public boolean hasChildren() {
        return this.node != null && this.node.getAll() != null && this.node.getAll().size() > 0;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public String getRunDuration() {
        long diff = this.endTime.getTime() - this.startTime.getTime();
        long secs = diff / 1000L;
        long millis = diff % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return hours + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + millis + "ms";
    }

    public void setStatus(Status status) {
        this.testStatus = status;
    }

    public Status getStatus() {
        return this.testStatus;
    }

    public void trackLastRunStatus() {
        this.getLogContext().getAll().forEach(x -> this.updateStatus(x.getStatus()));
        if (this.testStatus == Status.INFO) {
            this.testStatus = Status.PASS;
        }
    }

    private synchronized void updateStatus(Status logStatus) {
        int testStatusIndex;
        int logStatusIndex = Status.getStatusHierarchy().indexOf(logStatus);
        this.testStatus = logStatusIndex < (testStatusIndex = Status.getStatusHierarchy().indexOf(this.testStatus)) ? logStatus : this.testStatus;
    }

    public void end() {
        this.setEndTime(Calendar.getInstance().getTime());
        this.updateTestStatusRecursive(this);
        this.endChildrenRecursive(this);
        this.testStatus = this.testStatus == Status.INFO ? Status.PASS : this.testStatus;
    }

    private synchronized void updateTestStatusRecursive(Test test) {
        test.getLogContext().getAll().forEach(x -> this.updateStatus(x.getStatus()));
        if (test.hasChildren()) {
            test.node.getAll().forEach(this::updateTestStatusRecursive);
        }
    }

    private void endChildrenRecursive(Test test) {
        test.getNodeContext().getAll().forEach(Test::end);
    }

    public LogStructure getLogContext() {
        if (this.log == null) {
            this.log = new LogStructure();
        }
        return this.log;
    }

    public boolean hasLogs() {
        return this.log != null && this.log.getAll() != null && this.log.getAll().size() > 0;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
        if (this.hierarchicalName == null) {
            this.hierarchicalName = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHierarchicalName() {
        return this.hierarchicalName;
    }

    public boolean hasCategory() {
        return this.categoryList != null && !this.categoryList.isEmpty();
    }

    public void setCategory(TestAttribute category) {
        if (this.categoryList == null) {
            this.categoryList = new ArrayList<TestAttribute>();
        }
        this.categoryList.add(category);
    }

    public List<TestAttribute> getCategoryList() {
        return this.categoryList;
    }

    public boolean hasAuthor() {
        return this.authorList != null && !this.authorList.isEmpty();
    }

    public void setAuthor(TestAttribute author) {
        if (this.authorList == null) {
            this.authorList = new ArrayList<TestAttribute>();
        }
        this.authorList.add(author);
    }

    public List<TestAttribute> getAuthorList() {
        return this.authorList;
    }

    public void setExceptionInfo(ExceptionInfo ei) {
        if (this.exceptionList == null) {
            this.exceptionList = new ArrayList<ExceptionInfo>();
        }
        this.exceptionList.add(ei);
    }

    public List<ExceptionInfo> getExceptionInfoList() {
        return this.exceptionList;
    }

    public boolean hasException() {
        return this.exceptionList != null && !this.exceptionList.isEmpty();
    }

    public boolean hasMedia() {
        return this.scList != null && !this.scList.isEmpty();
    }

    public void setScreenCapture(ScreenCapture sc) {
        if (this.scList == null) {
            this.scList = new ArrayList<ScreenCapture>();
        }
        this.scList.add(sc);
    }

    public List<ScreenCapture> getScreenCaptureList() {
        return this.scList;
    }

    public boolean isBehaviorDrivenType() {
        return this.bddType != null;
    }

    public void setBehaviorDrivenType(IGherkinFormatterModel type) {
        this.bddType = type.getClass();
    }

    public void setBehaviorDrivenType(Class<? extends IGherkinFormatterModel> type) {
        this.bddType = type;
    }

    public Class<? extends IGherkinFormatterModel> getBehaviorDrivenType() {
        return this.bddType;
    }

    void setID(int id) {
        this.testID = id;
    }

    public int getID() {
        return this.testID;
    }

    public void setObjectId(ObjectId id) {
        this.mongoId = id;
    }

    public ObjectId getObjectId() {
        return this.mongoId;
    }
}

